/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * x11_dpms.c
 * X11 DPMS extension
 */

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/dpms.h>

#include <libxmm/xmmp.h>
#include <libxmm/util/utils.h>

/*
 * Definitions
 */

/* Change 'undef' in 'define' to get debug info */
#ifndef DEBUG
#undef	DEBUG
#endif

/* Change 'undef' in 'define' to even more information */
#ifndef VERBOSE
#undef	VERBOSE
#endif

int x11_dpms_off( Display *display )
{
  int		unknown1, unknown2, ret;
  CARD16	card16;

  if( DPMSQueryExtension( display, &unknown1, &unknown2 ) == 0 )
  {
	xmm_logging( 3, "X11(DPMS)! Extension not available...\n" );
	return XMM_RET_NOTSUPPORTED;
  }

#ifdef VERBOSE
  ret = DPMSGetVersion( display, &unknown1, &unknown2 );
  xmm_logging( 1, "X11(DPMS)! Version %i.%i\n", unknown1, unknown2 );
#endif

  ret = DPMSInfo( display, &card16, (BOOL *)&unknown1 );
#ifdef VERBOSE
  xmm_logging( 1, "X11(DPMS)! State %i\n", unknown1 );
#endif

  if( unknown1 == 0 )	return 0;

  DPMSDisable( display );

#ifdef DEBUG
  ret = DPMSInfo( display, &card16, (BOOL *)&unknown1 );
  xmm_logging( 1, "X11(DPMS)! State %i (new)\n", unknown1 );
#endif

  return 1;
}

/*
 * Activate DPMS
 */
int x11_dpms_on( Display *display )
{
  int		unknown1, unknown2;
#ifdef DEBUG
  CARD16	card16;
#endif

  if( DPMSQueryExtension( display, &unknown1, &unknown2 ) == 0 )
  {
	xmm_logging( 3, "X11(DPMS)! Extension not available...\n" );
	return XMM_RET_NOTSUPPORTED;
  }

#ifdef VERBOSE
  DPMSGetVersion( display, &unknown1, &unknown2 );
  xmm_logging( 1, "X11(DPMS)! Version %i.%i\n", unknown1, unknown2 );
#endif

  DPMSEnable( display );

#ifdef DEBUG
  DPMSInfo( display, &card16, (BOOL *)&unknown1 );
  xmm_logging( 1, "X11(DPMS)! State %i\n", unknown1 );
#endif

  return 0;
}
