/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_x11_xv_h
#define INC_x11_xv_h

#include <inttypes.h>
#include <errno.h>
#include <string.h>

#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>
#include <X11/extensions/Xvlib.h>

/*
 * Definitions
 */

/*
 * Types
 */

typedef struct xv_data_s
{
    /* Initialized by private function xv_init() */
    XvPortID		portID;
    XvImageFormatValues	*ifv;

    /* Initialized by xv_initData(), [ calls xv_init() ] */
    uint32_t		*aFormat;
    int			formats;

    /* Initialized by xv_start() */
    XvImage		*image;
    XShmSegmentInfo	shmInfo;

} xv_data_t;

#endif
