/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_aiff_h
#define INC_aiff_h

#include <inttypes.h>

/*
 * Definitions
 */

#define FORM_ID_FORM	0x464f524d		/* 'FORM' */
#define FORM_ID_AIFF	0x41494646		/* 'AIFF' */ 
#define FORM_ID_AIFC	0x41494643		/* 'AIFC' */ 

#define FORM_ID_COMM	0x434f4d4d		/* 'COMM' */ 
#define FORM_ID_SSND	0x53534e44		/* 'SSND' */ 
#define FORM_ID_MARK	0x4d41524b		/* 'MARK' */ 
#define FORM_ID_INST	0x494e5354		/* 'INST' */ 
#define FORM_ID_COMT	0x434f4d54		/* 'COMT' */ 
#define FORM_ID_AESD	0x41455344		/* 'AESD' */ 
#define FORM_ID_MIDI	0x4d494449		/* 'MIDI' */
#define FORM_ID_APPL	0x4150504c		/* 'APPL' */

#define	FORM_ID_NAME	0x4e414d45		/* 'NAME' */
#define	FORM_ID_AUTH	0x41555448		/* 'AUTH' */
#define	FORM_ID_COPY	0x28632920		/* '(c) ' */
#define	FORM_ID_DATE	0x414e4e4f		/* 'ANNO' */

/*
 * Types
 */

/*
 * COMM ( common ) chunk header [required]
 */
typedef struct __attribute__((packed))
{
    uint16_t		wChannels;
    uint32_t		dwFrames;
    uint16_t		wSampleSize;
    uint32_t		dwSampleRate;
} comm_header_t;

/*
 * SSND ( sound data ) chunk header
 */
typedef struct __attribute__((packed))
{
    uint32_t		dwOffset;
    uint32_t		dwBlockSize;
} ssnd_header_t;

/*
 * MARK ( marker ) chunk header
 */
typedef struct __attribute__((packed))
{
    uint16_t		wNumber;	/* number of marker_t items */
} mark_header_t;

/*
 *  marker
 */
typedef struct __attribute__((packed))
{
    uint16_t		wID;
    uint32_t		dwPosition;
    uint8_t		pcName[ 2 << sizeof(uint8_t) ];
} marker_t;

/*
 *  loop
 */
typedef struct __attribute__((packed))
{
#define	LOOP_NONE		0
#define	LOOP_FORWARD		1
#define	LOOP_FORWARD_BACKWARD	2
    uint16_t		wPlayMode;
    uint16_t		wLoopBegin;
    uint16_t		wLoopEnd;
} loop_t;

/*
 * INST ( instrument ) chunk header
 */
typedef struct __attribute__((packed))
{
    uint8_t		bBaseNote;		/* 0 to 127 ( 60 - Middle C ) */
    int8_t		cDetune;		/* -50 to 50 ( < 0 = lower ) */
    uint8_t		bLowNote;		/* Range: low */
    uint8_t		bHighNote;		/* Range: hight */
    uint8_t		bLowVelocity;		/* 1 to 127 */
    uint8_t		bHighVelocity;		/* 1 to 127 */
    int16_t		sGain;			/* gain ( decibels ) */

    loop_t		sustainLoop;
    loop_t		releaseLoop;
} inst_header_t;

/*
 * comment
 */
typedef struct __attribute__((packed))
{
    uint32_t		dwTimeStamp;
    uint16_t		wMarkerID;
    uint16_t		wSize;
    int8_t		*cText;
} comment_t;

/*
 * COMT ( comment ) chunk header
 */
typedef struct __attribute__((packed))
{
    uint16_t		wNumber;
} comt_header_t;


#endif
