/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_asfhead_h
#define INC_asfhead_h

#include <libxmm/lpio.h>
#include "asf.h"

int read_asf_chunk( XMM_PluginIO *pIO, asf_chunk_t *ach, int size );
int read_asf_header( XMM_PluginIO *pIO, asf_header_t *ahh, int size );
int read_asf_file( XMM_PluginIO *pIO, asf_file_t *afh, int size );
int read_asf_stream( XMM_PluginIO *pIO, asf_stream_t *ash, int size );
int read_asf_video_type( XMM_PluginIO *pIO, asf_video_type_t *avth, int size );
int read_asf_audio_spread( XMM_PluginIO *pIO, asf_audio_spread_t *aash, int size );
int read_asf_data( XMM_PluginIO *pIO, asf_data_t *adh, int size );
int read_asf_content( XMM_PluginIO *pIO, asf_content_t *ach, int size );

int decode_asf_packet_erco( uint8_t *data, asf_data_erco_t *ade, int size );
int decode_asf_packet_parse( uint8_t *data, asf_data_parse_t *adp, int size );
int decode_asf_segment( uint8_t *data, asf_data_parse_t *adp, asf_segment_t *asegh, int size );

void print_guid( GUID_t *guid );

#endif
