/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_au_h
#define INC_au_h

#include <inttypes.h>

/*
 * AU header
 */

typedef struct au_header_s
{
    /* magic number: ".snd" = 0x2e736e64 */

#define	AU_FORMAT_ID		0x2e736e64	/* '.snd' */
    uint32_t		dwID;

    /* Offset: data offset (in octets), minumum value is 24 */
    uint32_t		dwOffset;

    /* Size: data size (in octets), 0xffffffff if size unknown */
    uint32_t		dwSize;

    /* Format: encoding type */
#define	AU_DATA_ULAW		1	/* 8-bit ISDN u-law
 */
#define	AU_DATA_PCM8		2	/* 8-bit linear PCM
 */
#define	AU_DATA_PCM16		3	/* 16-bit linear PCM
 */
#define	AU_DATA_PCM24		4	/* 24-bit linear PCM */
#define	AU_DATA_PCM32		5	/* 32-bit linear PCM */
#define	AU_DATA_FLOAT		6	/* 32-bit IEEE floating point
 */
#define	AU_DATA_DOUBLE		7	/* 64-bit IEEE floating point */
#define	AU_DATA_G721		23	/* CCITT G.721 ADPCM
 (4-bit)
 */
#define	AU_DATA_G722		24	/* CCITT G.722 ADPCM
 */
#define	AU_DATA_G723_3		25	/* CCITT G.723 ADPCM
 (3-bit)
 */
#define	AU_DATA_G723_5		26	/* CCITT G.723 ADPCM
 (5-bit)
 */
#define	AU_DATA_ALAW		27	/* a-law
 */
    uint32_t		dwFormat;

    /* Rate: samples / second */
    uint32_t		dwRate;

    /* Channels: number of interleaved channels */
    uint32_t		dwChannels;


} au_header;

#endif
