/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_avifmt_h
#define INC_avifmt_h

#include <inttypes.h>

/*
 * RIFF Chunk ID's
 */

#define	RIFF_ID_RIFF	0x46464952	/* 'RIFF' */
#define RIFF_ID_AVI	0x20495641	/* 'AVI ' */
#define	RIFF_ID_LIST	0x5453494c	/* 'LIST' */
#define	RIFF_ID_hdrl	0x6C726468	/* 'hdrl' - LIST Header chunks */
#define RIFF_ID_avih	0x68697661	/* 'avih' - AVI main header */
#define	RIFF_ID_strl	0x6C727473	/* 'strl' - LIST Stream Header chunks */
#define	RIFF_ID_strh	0x68727473	/* 'strh' - Stream Header */
#define	RIFF_ID_strf	0x66727473	/* 'strf' - Stream Format */
#define	RIFF_ID_strd	0x64727473	/* 'strd' - Stream Data */
#define RIFF_ID_strn	0x6E727473	/* 'strn' - Stream Name */
#define	RIFF_ID_JUNK	0x4b4e554a	/* 'JUNK' - data alignment  */

#define	RIFF_ID_movi	0x69766f6d	/* 'movi' - LIST 'movi' chunk */
#define RIFF_ID_rec	0x20636572	/* 'rec ' - LIST 'rec ' chunk */
#define	RIFF_ID_01wb	0x62773130	/* 'wb'   - waveform chunk */
#define	RIFF_ID_00dc	0x63643030	/* 'dc'   - DIB compressed */
#define	RIFF_ID_00db	0x62643030	/* 'db'   - DIB bits ( uncompressed ) */
#define RIFF_ID_idx1	0x31786469	/* 'idx1' - List of data chunks */

/*
 * Format IDs
 */

#define WAVE_FORMAT_PCM			0x0001
#define WAVE_FORMAT_ADPCM		0x0002
#define	WAVE_FORMAT_IEEE_FLOAT		0x0003
#define	WAVE_FORMAT_ALAW		0x0006
#define	WAVE_FORMAT_MULAW		0x0007
#define	WAVE_FORMAT_DVI_ADPCM		0x0011
#define	WAVE_FORMAT_G723_ADPCM		0x0014
#define	WAVE_FORMAT_GSM610		0x0031
#define	WAVE_FORMAT_G721_ADPCM		0x0040
#define	WAVE_FORMAT_MPEG		0x0050
#define	WAVE_FORMAT_MPEGLAYER3		0x0055
#define	WAVE_FORMAT_G726_ADPCM		0x0064
#define	WAVE_FORMAT_WMA1		0x0160
#define	WAVE_FORMAT_WMA2		0x0161
#define	WAVE_FORMAT_AC3			0x2000

/*
 * INFO chunk
 * based on odmlff2.pdf
 */

#define	RIFF_ID_INFO	0x4f464e49	/* 'INFO' - LIST 'INFO' chunk */

/* Indicates where the subject of the file is archived. */
#define	RIFF_ID_IARL	0x4c524149	/* 'IARL' - Archival Location */
/* Lists the artist of the original subject of the file */
#define	RIFF_ID_IART	0x54524149	/* 'IART' - Artist */
/* Lists the name of the person or organization that commissioned the subject
   of the file */
#define RIFF_ID_ICMS	0x534d4349	/* 'ICMS' - Commissioned */
/* Provides general comments about the file or the subject of the file. If the
   comment is several sentences long, end each sentence with a period.
   Do not include new-line characters. */
#define RIFF_ID_ICMT	0x544d4349	/* 'ICMT' - Comments */
/* Records the copyright information for the file; for example, If there are
   multiple copyrights, separate them by a semicolon followed by a space. */
#define	RIFF_ID_ICOP	0x504f4349	/* 'ICOP' - Copyright */
/* Specifies the date the subject of the file was created. List dates in
   year-month-day format, padding one-digit months and days with a zero
   on the left; for example, "1553-05-03" for May 3, 1553. */
#define	RIFF_ID_ICRD	0x44524349	/* 'ICRD' - Creation date */
/* Describes whether an image has been cropped and, if so, how it was cropped;
   for example, "lower-right corner." */
#define	RIFF_ID_ICRP	0x50524349	/* 'ICRP' - Cropped */
/* Specifies the size of the original subject of the file; forexample,
    "8.5 in h, 11 in w." */
#define	RIFF_ID_IDIM	0x4d494449	/* 'IDIM' - Dimensions */
/* Stores dots per inch setting of the digitizer used to produce the file,
   such as "300." */
#define	RIFF_ID_IDPI	0x49504449	/* 'IDPI' - Dots Per Inch */
/* Stores the name of the engineer who worked on the file. If there are
   multiple engineers, separate the names by a semicolon and a blank;
   for example, "Smith, John; Adams, Joe." */
#define	RIFF_ID_IENG	0x474e4549	/* 'IENG' - Engineer */
/* Describes the original work, such as "landscape", "portrait",
   "still life," etc. */
#define	RIFF_ID_IGNR	0x524e4749	/* 'IGNR' - Genre  */
/* Provides a list of keywords that refer to the file or subject ofthe file.
   Separate multiple keywords with a semicolon and a blank; for example,
   "Seattle; aerial view; scenery." */
#define	RIFF_ID_IKEY	0x59454b49	/* 'IKEY' - Keywords */
/* Describes the changes in lightness settings on the digitizer required to
   produce the file. Note that the format of this information depends on
   hardware used. */
#define	RIFF_ID_ILGT	0x54474c49	/* 'ILGT' - Lightness */
/* Describes the original subject of the file, such as "computer image,"
    "drawing," "lithograph," and so on. */
#define	RIFF_ID_IMED	0x44454d49	/* 'IMED' - Medium */
/* Stores the title of the subject of the file, such as "Seattle FromAbove." */
#define	RIFF_ID_INAM	0x4d414e49	/* 'INAM' - Name */
/* Specifies the number of colors requested when digitizing an image,
   such as "256". */
#define	RIFF_ID_IPLT	0x544c5049	/* 'IPLT' - Palette Setting */
/* Specifies the name of the title the file was originally intended for,
   such as "Encyclopedia of Pacific Northwest Geography." */
#define	RIFF_ID_IPRD	0x44525049	/* 'IPRD' - Product */
/* Describes the contents of the file, such as "Aerial view of Seattle." */
#define	RIFF_ID_ISBJ	0x4a425349	/* 'ISBJ' - Subject */
/* Identifies the name of the software package used to create thefile,
   such as "Microsoft WaveEdit". */
#define	RIFF_ID_ISFT	0x54465349	/* 'ISFT' - Software */
/* Identifies the changes in sharpness for the digitizer required to produce
   the file (the format depends on the hardware used). */
#define	RIFF_ID_ISHP	0x50485349	/* 'ISHP' - Sharpness */
/* Identifies the name of the person or organization who supplied the original
   subject of the file; for example, "Trey Research". */
#define	RIFF_ID_ISRC	0x43525349	/* 'ISRC' - Source */
/* Identifies the original form of the material that was digitized, such as
   "slide", "paper", "map" and so on. This is not necessarily the same as IMED. */
#define	RIFF_ID_ISRF	0x46525349	/* 'ISRF' - Source Form */
/* Identifies the technician who digitized the subject file; for example,
   "Smith, John". */
#define	RIFF_ID_ITCH	0x48435449	/* 'ITCH' - Technician */

#define	RIFF_ID_odml	0x6c6d646f	/* ??? */
#define	RIFF_ID_dmlh	0x686c6d64	/* ??? */

/*
 * AVI stream header types
 */

#define	RIFF_STREAM_VIDEO		0x73646976	/* 'vids' */
#define	RIFF_STREAM_AUDIO		0x73647561	/* 'auds' */
#define RIFF_STREAM_MIDI		0x7364696d	/* 'mids' */
#define RIFF_STREAM_TEXT		0x73727872	/* 'txts' */

/*
 * ( RIFF ) AVI Header Flags
 */

	/* has an "idx1" chunk */
#define	AVIF_HASINDEX		0x00000010
	/* use idx1 chunk to determine the order of presentation of the data */
#define	AVIF_MUSTUSEINDEX	0x00000020
	/* AVI file is interleaved */
#define	AVIF_ISINTERLEAVED	0x00000100
	/* TODO : What is this ??? */
#define AVIF_TRUSTCKTYPE	0x00000800
	/* AVI file is used for capturing real-time video */
#define	AVIF_WASCAPTUREFILE	0x00010000
	/* Indicates the AVI file contains copyrighted data. */
#define	AVIF_COPYRIGHTED	0x00020000

/*
 * ( RIFF ) AVI stream header flags
 */

	/* Only render when explicitly enabled by user */
#define	AVISF_DISABLED		0x00000001
	/* Palette changes embedded in the file */
#define	AVISF_VIDEO_PALCHANGES	0x00010000

/*
 * AVI index entry flags
 */

	/* Chunk is LIST chunk */
#define AVIIF_LIST          0x00000001L
	/* keyframe doesn't need previous info to be decompressed */
#define AVIIF_KEYFRAME      0x00000010L
	/* Chunk does not affect timing of video stream, ie palette change */
#define AVIIF_NOTIME        0x00000100L

/*
 * Types
 */

/*
 * AVI Header
 */

typedef struct avi_header_s
{
    uint32_t	dwMicroSecPerFrame;
		/* Time / Frame */
    uint32_t	dwMaxBytesPerSec;
		/* Maximum transfer rate */
    uint32_t	dwReserved1;
    uint32_t	dwFlags;
    uint32_t	dwTotalFrames;
			/* Number of frames in file */
    uint32_t	dwInitialFrames;
    uint32_t	dwStreams;
    uint32_t	dwSuggestedBufferSize;
    uint32_t	dwWidth;
    uint32_t	dwHeight;
    uint32_t	dwScale;
    uint32_t	dwRate;
    uint32_t	dwStart;
    uint32_t	dwLength;
} avi_header_t;

/*
 * AVI Stream Header
 */

typedef struct avi_stream_header_s
{
    uint32_t	fccType;		/* 'vids' for video, 'auds' for audio */
    uint32_t	fccHandler;		/* compressor/decompressor fourcc */
    uint32_t	dwFlags;		/* Flags, AVIF_* */
    uint32_t	dwReserved1;
    uint32_t	dwInitialFrames;	/* used for interleaved files */
    uint32_t	dwScale;
    uint32_t	dwRate;			/* dwRate / dwScale = samples / sec */
    uint32_t	dwStart;		/* Starting time */
    uint32_t	dwLength;		/* Length */
    uint32_t	dwSuggestedBufferSize;	/* Size of playback buffer */
    uint32_t	dwQuality;		/* Data quality */
    uint32_t	dwSampleSize;		/* Sample size */
    uint16_t	dwReserved2[4];		/* rcFrame ( left, top, right, bottom ) */
} avi_stream_header_t;

/*
 * AVI Index entry
 */

typedef struct avi_index_entry_s
{
    uint32_t	dwChunkID;		/* FOURCC of the chunk */
    uint32_t	dwFlags;		/* Flags */
    uint32_t	dwChunkOffset;		/* Position of chunk */
    uint32_t	dwChunkLength;		/* Length of chunk */
} avi_index_entry_t;

/*
 * Bitmap format header
 *
 * defined in wingdi.h ( wine )
 */

#ifndef __WINE_WINGDI_H

typedef struct _BITMAPINFOHEADER
{
    uint32_t 	biSize;			/* long */
    uint32_t  	biWidth;		/* long */
    uint32_t  	biHeight;		/* long */
    uint16_t	biPlanes;		/* short */
    uint16_t	biBitCount;		/* short */
    uint32_t	biCompression;		/* long */
    uint32_t	biSizeImage;		/* long */
    uint32_t	biXPelsPerMeter;	/* long */
    uint32_t	biYPelsPerMeter;	/* long */
    uint32_t	biClrUsed;		/* long */
    uint32_t	biClrImportant;		/* long */
} BITMAPINFOHEADER;

typedef struct _BITMAPINFO
{
    BITMAPINFOHEADER	bmiHeader;
    int			bmiColors[1];
} BITMAPINFO;

#endif

/*
 * WAVE format header
 */

#ifndef _WAVEFORMATEX_
#define _WAVEFORMATEX_

typedef struct _WAVEFORMATEX
{
    uint16_t	wFormatTag;		/* Format */
    uint16_t	nChannels;		/* Channels */
    uint32_t	nSamplesPerSec;		/* Rate */
    uint32_t	nAvgBytesPerSec;	/* Average bytes / sec */
    uint16_t	nBlockAlign;		/* block size of data */
    uint16_t	wBitsPerSample;		/* Number of bits per sample */
    uint16_t	cbSize;			/* Size of extra data */
} WAVEFORMATEX;

#endif

#endif
