/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_cdda_h
#define INC_cdda_h

#include <libxmm/util/config.h>
#include "cdindex.h"

/*
 * Definitions
 */

/* CDDA modes */
#define	XMM_CDDA_READ		/* read mode - read raw audio data */
#define	XMM_CDDA_DOUT		/* direct out mode - use sound card directly */

/* Change 'undef' in 'define' to get verbose info */
#ifndef VERBOSE
#undef	VERBOSE
#endif

/*
 * Types
 */

struct priv_t
{
    int				FirstTrack, LastTrack, cTrack;
				/* CDDA can hold up to 99 audio tracks */
    struct cdr_tocentry		Track[100];
    struct cdr_discdata		Data;
    int				hasData;
    char			display[XMM_MAXPATHLEN];

    int 			fd;
    int				paused, stopped;

    XMM_ClipInfo		ci;
    XMM_AudioInfo		ai;
#ifdef XMM_CDDA_READ
    int				frames_cpos, frames_spos, frames_epos;
#endif
};

/*
 * Prototypes
 */

int cdda_read_init( XMM_PluginInput *input );
int cdda_dout_init( XMM_PluginInput *input );

#endif
