/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_cdindex_h
#define INC_cdindex_h

#include <inttypes.h>

/*
 * Definitions
 */

#define	CDDA_MAX_TRACKS		100
#define LBA(te)			(( te.minute * 60 + te.second ) * 75 + te.frame )

/*
 * CD index
 */

#define	CDDA_ARTIST_MULTIPLE	1
#define	CDDA_ARTIST_SINGLE	2

struct cdr_tocentry		/* track position */
{
	uint8_t			minute;
	uint8_t			second;
	uint8_t			frame;
	uint8_t			type;
};

struct cdr_trackdata		/* track data */
{
	char 			artist[256];
	char 			title[256];
};

struct cdr_discdata		/* disc data */
{
	char			title[256];
	int			artistType;
	struct cdr_trackdata	track[CDDA_MAX_TRACKS];
};

/*
 * Prototypes
 */

int cdindex_get_info( void *xmm, char *cdindex_server, int FirstTrack, int LastTrack, struct cdr_tocentry *Track, struct cdr_discdata *Data );

#endif
