/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_mpg123head_h
#define INC_mpg123head_h

#include <inttypes.h>

/*
 * Definitions
 */

#define VBR_TOC_ENTRIES		100

/*
 * Flags
 */

#define VBR_FLAG_FRAMES		0x0001
#define VBR_FLAG_BYTES		0x0002
#define VBR_FLAG_TOC		0x0004
#define VBR_FLAG_SCALE		0x0008

/*
 * VBR Header
 */

typedef struct VBRHeader_s
{
	uint32_t	flags;
	uint32_t	frames;
	uint32_t	bytes;
	uint32_t	scale;
	uint8_t		toc[VBR_TOC_ENTRIES];
} VBRHeader;

/*
 * Info struct
 */

typedef struct _mpg123_info
{
    /* Calculated stuff */
    uint32_t	bitrate;
    uint32_t	samprate;
    uint32_t	channels;

    double	bpf, tpf;
    uint32_t	framesize;

    /* System */
    uint32_t	mpeg;
    uint32_t	layer;

    /* Flags */
    uint16_t	mode;
    uint16_t	crc;
    uint16_t	copyright;
    uint16_t	original;

    /* Other */
    uint32_t	emphasis;
} MPG123_Info;

/*
 * Prototypes
 */

#define	MPG123_DECINFO_NOHEADER	-32768

int MPG123_DecodeInfo( uint8_t *buffer, int size, MPG123_Info *info, VBRHeader *vbrhead, int *vbrhead_found );

#endif
