/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_au_h
#define INC_au_h

#include <inttypes.h>

/*
 * Definitions
 */

#define	VOC_TYPE_TERMINATOR		0x00
#define	VOC_TYPE_SOUND_DATA		0x01
#define	VOC_TYPE_SOUND_CONT		0x02
#define	VOC_TYPE_SILENCE		0x03
#define	VOC_TYPE_MARKER			0x04
#define	VOC_TYPE_ASCII			0x05
#define	VOC_TYPE_REPEAT			0x06
#define	VOC_TYPE_REPEAT_END		0x07
#define	VOC_TYPE_EXTENDED		0x08
#define	VOC_TYPE_SOUND_DATA_NEW		0x09

/*
 * VOC header
 */

typedef struct __attribute__((packed)) voc_header_s
{
#define	VOC_FORMAT_ID		"Creative Voice File"
    uint8_t		pcID[19];

#define	VOC_FORMAT_ID_EOF	0x1A
    uint8_t		cID;

    uint16_t		wOffset;	/* Offset of first data block (LE) */

#define	VOC_VERSION10		0x010A
#define	VOC_VERSION20		0x0114
    uint16_t		wVersion;	/* Version: minor, major */
    uint16_t		wVersion2;	/* 1's complement of version */


} voc_header;

typedef struct __attribute__((packed)) voc_snd_info_s
{
#define	VOC_SRB2RATE(b)		( 1000000 / ( 256 - b))
    uint8_t		sr;
    uint8_t		df;
} voc_snd_info;

typedef struct __attribute__((packed)) voc_snd_info2_s
{
    uint32_t		dwSampleRate;
    uint8_t		bSampleSize;
    uint8_t		bChannels;
    uint8_t		bUnknown1;
    uint8_t		pbUnknown2[5];
} voc_snd_info2;

typedef struct __attribute__((packed)) voc_silence_s
{
    uint16_t		wLength;
    uint8_t		sr;
} voc_silence;

typedef struct __attribute__((packed)) voc_marker_s
{
    uint16_t		value;
} voc_marker;

typedef struct __attribute__((packed)) voc_repeat_s
{
    uint16_t		value;
} voc_repeat;

typedef struct __attribute__((packed)) voc_extended_s
{
    uint16_t		wTimeConstant;
    uint8_t		bPack;
    uint8_t		bMode;
} voc_extended;

#endif
