#
# Configure paths for LinuX MultiMedia Project
#
# last modified 22.10.2001, by Arthur Kleer
# ( based on libmikmod.m4 )

dnl Usage
dnl AM_PATH_XMMP([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND ]]])
dnl
dnl Check for xmmp, and define XMMP_PREFIX, XMMP_VERSION,
dnl XMMP_LIBXMM_CFLAGS, XMMP_LIBXMM_LIBS,
dnl XMMP_MPLAYER_CFLAGS, XMMP_MPLAYER_LIBS, 
dnl XMMP_PLUGINDIR, XMMP_DATADIR and XMMP_THEMEDIR
dnl

AC_DEFUN(AM_PATH_XMMP,
[
dnl
dnl Get cflags and libs from xmmp-config script
dnl
AC_ARG_WITH(xmmp-prefix,[  --with-xmmp-prefix=PFX  Prefix where XMMP is installed (optional)],
            xmmp_config_prefix="$withval", xmmp_config_prefix="")
AC_ARG_ENABLE(xmmp-test,[  --disable-xmmp-test     Do not try to compile and run a test program],
		    , enable_xmmptest=yes)

  if test x$xmmp_config_prefix != x ; then
    xmmp_config_args="$xmmp_config_args --prefix=$xmmp_config_prefix"
    if test x${XMMP_CONFIG+set} != xset ; then
	XMMP_CONFIG=$xmmp_config_prefix/bin/xmmp-config
    fi
  fi

  AC_PATH_PROG(XMMP_CONFIG, xmmp-config, no)
  min_xmmp_version=ifelse([$1], ,0.6.0,$1)

  if test "$XMMP_CONFIG" = "no" ; then
    no_xmmp=yes
  else

    no_xmmp=""

    XMMP_PREFIX=`$XMMP_CONFIG $xmmp_config_args --prefix`
    XMMP_VERSION=`$XMMP_CONFIG $xmmp_config_args --version`

    XMMP_LIBXMM_CFLAGS=`$XMMP_CONFIG $xmmp_config_args --cflags`
    XMMP_LIBXMM_LIBS=`$XMMP_CONFIG $xmmp_config_args --libs`
    XMMP_MPLAYER_CFLAGS=`$XMMP_CONFIG $xmmp_config_args --mplayer-cflags`
    XMMP_MPLAYER_LIBS=`$XMMP_CONFIG $xmmp_config_args --mplayer-libs`

    XMMP_PLUGINDIR=`$XMMP_CONFIG $xmmp_config_args --plugindir`
    XMMP_DATADIR=`$XMMP_CONFIG $xmmp_config_args --datadir`
    XMMP_THEMEDIR=`$XMMP_CONFIG $xmmp_config_args --themedir`

    AC_MSG_CHECKING(for LinuX MultiMedia Project - version >= $min_xmmp_version)

    xmmp_config_major_version=`$XMMP_CONFIG $xmmp_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\1/'`
    xmmp_config_minor_version=`$XMMP_CONFIG $xmmp_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\2/'`
    xmmp_config_micro_version=`$XMMP_CONFIG $xmmp_config_args --version | \
           sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\).*/\3/'`

dnl
dnl Now check if the installed XMMP is sufficiently new.
dnl

    if test "x$enable_xmmptest" = "xyes" ; then
	ac_save_CFLAGS="$CFLAGS"
	ac_save_LIBS="$LIBS"
	CFLAGS="$CFLAGS $XMMP_LIBXMM_CFLAGS"
	LIBS="$LIBS $XMMP_LIBXMM_LIBS"

	rm -f conf.xmmptest
	AC_TRY_RUN([

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libxmm/libxmm.h>

char *my_strdup( char *str )
{
  char *new_str;

  if( str )
  {
	new_str = malloc(( strlen( str ) + 1 ) * sizeof( char ) );
	strcpy( new_str, str );
  }
  else	new_str = NULL;

  return new_str;
}

int main()
{
  int major, minor, micro;
  char *tmp_version;

  system("touch conf.xmmptest");

  /* HP/UX 9 (%@#!) writes to sscanf strings */
  tmp_version = my_strdup("$min_xmmp_version");
  if( sscanf( tmp_version, "%d.%d.%d", &major, &minor, &micro ) != 3 )
  {
	printf("%s, bad version string\n", "$min_xmmp_version");
	exit(1);
  }

  if(( $xmmp_config_major_version > major ) ||
    (( $xmmp_config_major_version == major ) &&
    ( $xmmp_config_minor_version > minor )) ||
    (( $xmmp_config_major_version == major ) &&
    ( $xmmp_config_minor_version == minor ) &&
    ( $xmmp_config_micro_version >= micro )))
  {
	return 0;		// Success
  }
  else
  {
    printf( "\n*** An old version of XMMP was found ( %i.%i.%i ).\n",
						$xmmp_config_major_version,
						$xmmp_config_minor_version,
						$xmmp_config_micro_version );
    printf( "*** You should upgrade to a version newer than %i.%i.%i.\n***\n",
						major, minor, micro );
    printf( "*** If you have already installed a sufficiently new version, this probably\n" );
    printf( "*** means that xmmp-config was wrong. In this case set the enviroment variable\n" );
    printf( "*** XMMP_CONFIG to point to the correct copy of xmmp-config.\n" );
  }

  return 1;
}

],, no_xmmp=yes,[echo $ac_n "cross compiling; assumed OK... $ac_c"])

	CFLAGS="$ac_save_CFLAGS"
	LIBS="$ac_save_LIBS"
     fi
  fi

dnl
dnl * * * Filnal stuff ( Print messages, ... )
dnl

  if test "x$no_xmmp" = x ; then
    AC_MSG_RESULT([yes, "$XMMP_VERSION" ])
    ifelse([$2], , :, [$2])
  else
    AC_MSG_RESULT(no)
    if test "$XMMP_CONFIG" = "no" ; then
	echo "*** The xmmp-config script installed by XMMP could not be found"
	echo "*** If XMMP was installed in PREFIX, make sure PREFIX/bin is in"
	echo "*** your path, or set the XMMP_CONFIG environment variable to the"
	echo "*** full path to xmmp-config."
    fi
    XMMP_PREFIX=""
    XMMP_VERSION=""

    XMMP_LIBXMM_CFLAGS=""
    XMMP_LIBXMM_LIBS=""
    XMMP_MPLAYER_CFLAGS=""
    XMMP_MPLAYER_LIBS=""

    XMMP_PLUGINDIR=""
    XMMP_DATADIR=""
    XMMP_THEMEDIR=""
    ifelse([$3], , :, [$3])
  fi

  AC_SUBST(XMMP_PREFIX)
  AC_SUBST(XMMP_VERSION)

  AC_SUBST(XMMP_LIBXMM_CFLAGS)
  AC_SUBST(XMMP_LIBXMM_LIBS)
  AC_SUBST(XMMP_MPLAYER_CFLAGS)
  AC_SUBST(XMMP_MPLAYER_LIBS)

  AC_SUBST(XMMP_PLUGINDIR)
  AC_SUBST(XMMP_DATADIR)
  AC_SUBST(XMMP_THEMEDIR)

  rm -f conf.xmmptest
])
