/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_mplayer_h
#define INC_mplayer_h

#include <gtk/gtk.h>

#include <libmplayer/support.h>
#include <libmplayer/mplayertypes.h>
#include <libmplayer/mplayerwidgets.h>

#ifdef __cplusplus
extern "C"
{
#endif

//
// Definitions
//

#define	MPLAYER_FILESEL_OK		1
#define	MPLAYER_FILESEL_SELECT		2

#define	MPLAYER_DIRSEL_ISFILE		128

#define	MPLAYER_FILESEL_BUTTONS		1	// Show select buttons
#define	MPLAYER_DIRSEL_GETFILES		1	// return files instead of dir

//
// Prototypes
//

int	mplayer_LoadTheme( char *theme, char *skin, mptTheme *tdesc );
void	mplayer_FreeTheme( mptTheme *tdesc );
void	mplayer_InitTheme( mptTheme *tdesc, int state );
int	mplayer_ReloadDock( char *theme, char *skin );

void	mplayer_WidgetDrawAll( mptTheme *tdesc );
void	mplayer_WidgetVisible( void *w, int state );

void	mplayer_ShowWindow( mptTheme *theme );
void	mplayer_HideWindow( mptTheme *theme );

void	mplayer_Message( char *label, char *text );
void	mplayer_FileSelect( int mode, char *path, void (*_LoadDialogCallback)( char *filename, int mode ));
void	mplayer_DirSelect( int mode, void (*_LoadDialogCallback)( char *path, int mode ));
void	mplayer_UrlSelect( GList *url_history, void (*_LoadDialogCallback)( char *url ));
void	mplayer_SkinBrowser( void );

#ifdef __cplusplus
}
#endif

#endif
