/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_mplayertypes_h
#define INC_mplayertypes_h

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C"
{
#endif

//
// Definitions
//

#define	MPLAYER_BUTTON_LEFT	1
#define	MPLAYER_BUTTON_RIGHT	3

#define	MPLAYER_EVENT_FOCUS_IN		1
#define	MPLAYER_EVENT_FOCUS_OUT		2
#define	MPLAYER_EVENT_BUTTON_PRESS	3
#define	MPLAYER_EVENT_BUTTON_RELEASE	4
#define	MPLAYER_EVENT_MOTION		5
#define	MPLAYER_EVENT_THEMECHANGE	6

//
// Types
//

typedef struct mpsWidget	mptWidget;
typedef struct mpsWidgetEntry	mptWidgetEntry;
typedef struct mpsTheme		mptTheme;
typedef struct mpsEvent		mptEvent;
typedef struct mpsEventMouse	mptEventMouse;
typedef struct mpsEventTheme	mptEventTheme;

//
// Widget. Common to all widgets
//

struct mpsWidget
{
    GdkWindow	*window;	// Target Drawable
    GdkGC	*gc;		// Graphic context of the target drawble
    GdkPixmap	*pixmap;	// Pixmap with source data
    GdkBitmap	*mask;		// ??? is it really used ?
    mptTheme	*theme;
    int		x;
    int		y;
    int		width;
    int		height;
    int		visible;
    void	(*cbDraw)( struct mpsWidget *widget );
    int		(*cbButtonPress)( GtkWidget *gtkwidget, GdkEventButton *event, struct mpsWidget *widget );
    int		(*cbButtonRelease)( GtkWidget *gtkwidget, GdkEventButton *event, struct mpsWidget *widget );
    int		(*cbMotion)( GtkWidget *gtkwidget, GdkEventButton *event, struct mpsWidget *widget );
// Callbacks
    void	(*ChangeCallback)( int value );
    void	(*ReleaseCallback)( int value );
// Free widget
    void	(*Free)( struct mpsWidget *widget );
};

//
// Widget Table Entry
//

struct mpsWidgetEntry
{
    char	name[256];
    mptWidget	**pWidget;

// Default pixmap
    char	**defpixmap;

// Callbacks
    void	(*ReleaseCallback)( int value );
    void	(*ChangeCallback)( int value );

// Internal
    char	pixmapfile[256];
    GdkPixmap	*pixmap;
};

//
// Theme. Needed by LoadTheme()
//

struct mpsTheme
{
    mptWidgetEntry	*wtable;
    int			wnum;
    char		section[64];
    char		**skin_def;		// We need this indirection to make Pre-Initialization possible
    int			enableDouble;
    char		title[256];
    void		(*cbMPlayerEvent)( mptTheme *theme, mptWidget *widget, mptEvent *event );

//
// These don't need to be initialized by the application
//

    char		theme_dir[256];
    char		skin_name[256];

    // Initialized by mplayer_LoadTheme(), can be used by application
    GtkWidget		*window;
    GList		*wlist;

    // Needed for moving the window
    int			mb_pressed;
    int			mb_pressed_x;
    int			mb_pressed_y;
    mptWidget		*mb_pressed_w;

    // Visible
    int			visible;
    int			doubleState;

    // Internal
    GdkPixmap		*pixmap;
    GdkBitmap		*mask_ds;
    GdkGC		*gc;
};

//
// mplayer event type
//

struct mpsEventMouse
{
    int		x;
    int		y;
    int		button;
};

struct mpsEventTheme
{
    char	theme[256];
    char	skin[256];
};

struct mpsEvent
{
    int		type;
    union
    {
	mptEventMouse	mouse;
	mptEventTheme	theme;
    } data;
};

#ifdef __cplusplus
}
#endif

#endif
