/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * File I/O dialog
 */

#include <string.h>
#include <sys/stat.h>

#include <gtk/gtk.h>
#include <libmplayer/mplayer.h>

#include "interface.h"
#include "support.h"

//
// Prototypes
//

static void on_add_all_button_clicked( GtkButton *button, gpointer user_data );
static void on_add_selected_button_clicked( GtkButton *button, gpointer user_data );

//
// Global data
//

static GtkWidget	*file_window;
static void		(*LoadDialogCallback)( char *filename, int mode );
static char		*current_dir;

//
// Create dialog
//

void mplayer_FileSelect( int mode, char *path, void (*_LoadDialogCallback)( char *filename, int mode ))
{
  GtkWidget *fileio_hbbox, *fileio_selected, *fileio_all;

  file_window = create_mplayer_fileio_window();

  current_dir = path;
  if( current_dir[ strlen( current_dir ) - 1 ] != '/' )	strcat( current_dir, "/" );
  gtk_file_selection_set_filename( GTK_FILE_SELECTION( file_window), current_dir );

  gtk_clist_set_selection_mode(
		    GTK_CLIST( GTK_FILE_SELECTION( file_window )->file_list ),
		    GTK_SELECTION_EXTENDED );
  if( mode )
  {
	fileio_hbbox = gtk_hbutton_box_new();

	gtk_button_box_set_spacing( GTK_BUTTON_BOX( fileio_hbbox ), 0 );
	gtk_button_box_set_layout( GTK_BUTTON_BOX( fileio_hbbox ), GTK_BUTTONBOX_END );
	gtk_box_pack_start( GTK_BOX( GTK_FILE_SELECTION( file_window )->main_vbox ), fileio_hbbox, TRUE, TRUE, 0);

	fileio_selected = gtk_button_new_with_label( "Add selected" );
	gtk_box_pack_start( GTK_BOX( fileio_hbbox ), fileio_selected, FALSE, FALSE, 0 );
	gtk_signal_connect( GTK_OBJECT( fileio_selected ), "clicked",
			GTK_SIGNAL_FUNC( on_add_selected_button_clicked ), NULL );

	fileio_all = gtk_button_new_with_label( "Add all" );
	gtk_box_pack_start( GTK_BOX( fileio_hbbox ), fileio_all, FALSE, FALSE, 0 );
	gtk_signal_connect( GTK_OBJECT( fileio_all ), "clicked",
			GTK_SIGNAL_FUNC( on_add_all_button_clicked ), NULL );

	gtk_widget_show_all( fileio_hbbox );
  }

  gtk_widget_show( file_window );
  LoadDialogCallback = _LoadDialogCallback;
}

//
// Private stuff
//

static void on_add_all_button_clicked( GtkButton *button, gpointer user_data )
{
  GtkFileSelection *fs = (GtkFileSelection *) file_window;
  GList *le;
  char *ptr, *ptr2;

  gtk_clist_freeze( GTK_CLIST( fs->file_list ));
  gtk_clist_select_all( GTK_CLIST( fs->file_list ));	// Not in tutorial, see gtkclist.h

  ptr2 = g_dirname( gtk_file_selection_get_filename( fs ));
  strcpy( current_dir, ptr2 );
  g_free( ptr2 );

  for( le = GTK_CLIST( fs->file_list )->selection; le; le = le->next )
  {
	gtk_clist_get_text( GTK_CLIST( fs->file_list ), (int) le->data, 0, &ptr );
	ptr2 = g_strconcat( current_dir, "/", ptr, NULL );
	LoadDialogCallback( ptr2, MPLAYER_FILESEL_SELECT );
	g_free( ptr2 );
  }

  gtk_clist_unselect_all( GTK_CLIST( fs->file_list ));
  gtk_clist_thaw( GTK_CLIST( fs->file_list ));
}

static void on_add_selected_button_clicked( GtkButton *button, gpointer user_data )
{
  GtkFileSelection *fs = (GtkFileSelection *) file_window;
  GList *le;
  char *ptr, *ptr2;

  ptr2 = g_dirname( gtk_file_selection_get_filename( fs ));
  strcpy( current_dir, ptr2 );
  g_free( ptr2 );

  for( le = GTK_CLIST( fs->file_list )->selection; le; le = le->next )
  {
	gtk_clist_get_text( GTK_CLIST( fs->file_list ), (int) le->data, 0, &ptr );
	ptr2 = g_strconcat( current_dir, "/", ptr, NULL );
	LoadDialogCallback( ptr2, MPLAYER_FILESEL_SELECT );
	g_free( ptr2 );
  }
}

//
// Needs to be non-static, needed by interface.c
//

void on_load_button_clicked( GtkButton *button, gpointer user_data )
{
  char *fn, *ptr;
  GtkFileSelection *fs = (GtkFileSelection *) file_window;
  struct stat buf;

  fn = gtk_file_selection_get_filename( fs );
  if( fn[ strlen( fn ) - 1 ] == '/' )	fn[ strlen( fn ) - 1 ] = '\0';

  if( stat( fn, &buf ) == 0)
  {
	if( S_ISDIR( buf.st_mode ))
	{
		ptr = g_strdup_printf( "%s/", fn );
		gtk_file_selection_set_filename( fs, ptr );
		g_free( ptr );
		return;
	}
  }

  ptr = g_dirname( fn );
  strcpy( current_dir, ptr );
  g_free( ptr );

  ptr = g_strdup( fn );	// save filename, before destroying widget
  gtk_widget_destroy( file_window );
  LoadDialogCallback( ptr, MPLAYER_FILESEL_OK );
  g_free( ptr );
}
