/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * parser.c
 * Functions called by the widget parsers
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include <gtk/gtk.h>
#include <libxmm/libxmm.h>
#include <libxmm/util/utils.h>
#include <libmplayer/mplayertypes.h>
#include "gtkwin.h"

//
// Functions for parsing data types
//

int ReadCoord( char *string, int *x1, int *x2 )
{
  char *ptr = string;

  if( *ptr == '"' )	ptr++;
  *x1 = strtol( ptr, &ptr, 0 );
  if( *ptr != ',' )	return 0;
  *x2 = strtol( ptr + 1, &ptr, 0 );
  if( *ptr != '"' )	return 0;

  return 1;
}

int ReadOrd( char *string, int *x )
{
  char *ptr = string;

  if( *ptr == '"' )	ptr++;
  *x = strtol( ptr, &ptr, 0 );
  if( *ptr != '"' )	return 0;

  return 1;
}

int ReadArray( char *string, int *x, int max )
{
  char *ptr = string;
  int n = 0;

  if( *ptr == '"' )	ptr++;

  do
  {
	x[n] = strtol( ptr, &ptr, 0 );

	n++;
	if(( *ptr == ',' ) || ( *ptr == '"' ))	ptr++;
	else	return 0;

  } while(( *ptr != '"' ) && ( n < max ));

  return n;
}

int ReadString( char *string, char *dest )
{
  char *ptr = string, *ptr2;

  if( *ptr != '"' )	return 0;
  else	ptr++;

  if(( ptr2 = strchr( ptr, '"' )) == NULL )	return 0;

  strncpy( dest, ptr, strlen( ptr ) - 1 );
  dest[ strlen( ptr ) - 1 ] = '\0';

  return 1;
}

//
// Loads pixmap and sets pointer to widget according to the table
//

int LookupWidget( mptTheme *theme, char *name, char *pixmapfile, mptWidget *sw )
{
  int i, j;
  char temp[256], *filename;

  for( i = 0; i < theme->wnum; i++ )
	if( !strcmp( name, theme->wtable[i].name ))	break;

  if( i == theme->wnum )
  {
	g_print( "ERROR: Cannot lookup widget pixmap/pointer for %s\n", name );
	return 0;
  }

  if(( i == 0 ) && ( theme->pixmap == NULL ))
  {
	if( theme->window )	gtk_widget_set_usize( GTK_WIDGET( theme->window ), sw->width, sw->height );
	else	theme->window = mpint_CreateGtkWindow( theme, 200, 200, sw->width, sw->height, theme->title );
	theme->pixmap = gdk_pixmap_new( theme->window->window, sw->width, sw->height, gdk_rgb_get_visual()->depth );
	if( theme->pixmap == NULL )
	{
	    g_print( "ERROR: Cannot create pixmap/buffer\n" );
	    return 0;
	}
	theme->gc = //gdk_gc_new( theme->window->window );
	theme->window->style->fg_gc[ GTK_WIDGET_STATE( theme->window )];

	if( theme->gc == NULL )
	{
	    g_print( "ERROR: Cannot create graphic context\n" );
	    return 0;
	}
  }

  if( pixmapfile )
  {
    for( j = 0; j < theme->wnum; j++ )
	if( !strcmp( pixmapfile, theme->wtable[j].pixmapfile ))	break;

    if( j == theme->wnum )
    {
	strcpy( theme->wtable[i].pixmapfile, pixmapfile );

	strcpy( temp, theme->theme_dir );
	strcat( temp, "/" );
	strcat( temp, theme->skin_name );
	if( theme->skin_name[0] )	strcat( temp, "/" );
	strcat( temp, pixmapfile );

	filename = xmm_gethome_filename( temp );

	sw->pixmap = gdk_pixmap_create_from_xpm(    theme->window->window, &sw->mask,
						    &(theme->window->style->bg[GTK_STATE_NORMAL]),
						    filename );

	if( sw->pixmap == NULL )
	{
	    sw->pixmap = gdk_pixmap_create_from_xpm_d(	theme->window->window, &sw->mask,
							&(theme->window->style->bg[GTK_STATE_NORMAL]),
							theme->wtable[i].defpixmap );
	}

	if( sw->pixmap == NULL )
	{
		g_print( "ERROR: Cannot create pixmap: Neither from %s nor from default skin\n", pixmapfile );
		g_print( "ERROR: Full Path: %s\n", filename );
		g_print( "ERROR: Cannot lookup widget pixmap/pointer for %s\n", name );
		free( filename );
		return 0;
	}

	free( filename );

	theme->wtable[i].pixmap = sw->pixmap;
    }
    else	sw->pixmap = theme->wtable[j].pixmap;
  }

  sw->window = theme->pixmap;	//(*(theme->window))->window
  sw->gc = theme->gc;
  sw->theme = theme;

  sw->ChangeCallback = theme->wtable[i].ChangeCallback;
  sw->ReleaseCallback = theme->wtable[i].ReleaseCallback;

  *theme->wtable[i].pWidget = sw;

  sw->visible = 1;
  theme->wlist = g_list_append( theme->wlist, sw );

  return 1;
}
