/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Skin browser
 */

#include <stdio.h>
#include <stdlib.h>
#include <dirent.h>
#include <sys/stat.h>

#include <gtk/gtk.h>
#include "interface.h"
#include "support.h"

#include <libmplayer/mplayer.h>
#include <libxmm/libxmm.h>
#include <libxmm/util/utils.h>

//
// Type definitions
//

typedef struct _theme_t
{
    char	*name;
    char	*path;
    GList	*skins;
    void	*item;
} ThemeNode;

//
// Global data
//

static GList *ThemeList;

//
// Prototypes
//

static GList *ScanThemeDir( char *dirname, GList *list );

//
// Public code
//

void mplayer_SkinBrowser( void )
{
  GtkWidget	*sbr_window;
  GtkWidget	*sbr_tree;
  GList		*let, *les;
  GtkWidget	*subtree;
  char		*ptr;
  ThemeNode	*theme;

  ThemeList = NULL;
  
// Add default skin

  theme = g_malloc( sizeof( ThemeNode ));
  theme->name = g_strdup( "(default)" );
  theme->path = g_strdup( "(default)" );
  theme->skins = NULL;
  ThemeList = g_list_append( ThemeList, theme );

// Add system wide skins

  ThemeList = ScanThemeDir( LIBDIR "Themes", ThemeList );

// Add personal Skins

  ptr = xmm_gethome_filename( "Themes" );
  if( ptr )
  {
	ThemeList = ScanThemeDir( ptr, ThemeList );
	free( ptr );
  }

  sbr_window = create_mplayer_skinbroser_window();
  sbr_tree = lookup_widget( sbr_window, "skin_tree" );

  for( let = ThemeList; let; let = let->next )
  {
//	printf( "Theme: %s ( %s )\n", ((ThemeNode *)let->data)->name, ((ThemeNode *)let->data)->path );

	((ThemeNode *)let->data)->item = gtk_tree_item_new_with_label( ((ThemeNode *)let->data)->name );
	gtk_tree_append( GTK_TREE( sbr_tree ), ((ThemeNode *)let->data)->item );
	gtk_widget_show( ((ThemeNode *)let->data)->item );

	if( ((ThemeNode *)let->data)->skins )
	{
	    subtree = gtk_tree_new();
	    gtk_tree_item_set_subtree( GTK_TREE_ITEM( ((ThemeNode *)let->data)->item ), subtree );

	    for( les = ((ThemeNode *)let->data)->skins; les; les = les->next )
	    {
		((ThemeNode *)les->data)->item = gtk_tree_item_new_with_label( ((ThemeNode *)les->data)->name );
		gtk_tree_append( GTK_TREE( subtree ), ((ThemeNode *)les->data)->item );
		gtk_widget_show( ((ThemeNode *)les->data)->item );
	    }
	}
  }

  gtk_widget_show( sbr_window );
}

//
// Public ( needed by interface.c )
//

void on_skin_tree_selection_changed( GtkTree *tree, gpointer user_data )
{
  GList *i;
  GList *let, *les;
  
  for( i = GTK_TREE_SELECTION(tree); i; i = i->next )
  {
	gchar *name;
	GtkLabel *label;
	GtkWidget *item;

	item = GTK_WIDGET( i->data );
	label = GTK_LABEL( GTK_BIN( item )->child );
	gtk_label_get( label, &name );

	for( let = ThemeList; let; let = let->next )
	{
	    if( item == ((ThemeNode *)let->data)->item )
	    {
		mplayer_ReloadDock( ((ThemeNode *)let->data)->path, "" );
		break;
	    }

	    if( GTK_TREE( item->parent )->level != 1 )	continue;

	    for( les = ((ThemeNode *)let->data)->skins; les; les = les->next )
	    {
		if( item == ((ThemeNode *)les->data)->item )
		{
		    mplayer_ReloadDock( ((ThemeNode *)let->data)->path, ((ThemeNode *)les->data)->name );
		    break;
		}
	    }
	}
  }
}

//
// Private code
//

static GList *ScanSkinDir( char *dirname, GList *list )
{
  DIR		*ds;
  struct dirent	*dir;
  struct stat	buf;
  char		*filename;
  GList		*oldlist = list;
  ThemeNode	*theme;

  ds = opendir( dirname );
  if( ds )
  {
	while(( dir = readdir( ds )) != NULL )
	{
	    if( !strcmp( dir->d_name, "." ) || !strcmp( dir->d_name, ".." ))
		    continue;

	    filename = g_malloc( strlen( dirname ) + strlen( dir->d_name ) + 2 );
	    sprintf( filename, "%s/%s", dirname, dir->d_name );

	    if( stat( filename, &buf ) == 0 )
	    {
		    if( S_ISDIR( buf.st_mode ))
		    {
			theme = g_malloc( sizeof( ThemeNode ));
			theme->name = g_strdup( dir->d_name );
			theme->path = filename;
			theme->skins = NULL;

			list = g_list_append( list, theme );
		    }
		    else	g_free( filename );
	    }
	    else	g_free( filename );
	}
  }
  else	fprintf( stderr, "Theme! Cannot open skin dir %s\n", dirname );

  if( list == oldlist )	return NULL;
  else	return list; 
}

static GList *ScanThemeDir( char *dirname, GList *list )
{
  DIR		*ds;
  struct dirent	*dir;
  struct stat	buf;
  char		*filename;
  ThemeNode	*theme;

  ds = opendir( dirname );
  if( ds )
  {
	while(( dir = readdir( ds )) != NULL )
	{
	    if( !strcmp( dir->d_name, "." ) || !strcmp( dir->d_name, ".." ))
		    continue;

	    filename = g_malloc( strlen( dirname ) + strlen( dir->d_name ) + 2 );
	    sprintf( filename, "%s/%s", dirname, dir->d_name );

	    if( stat( filename, &buf ) == 0 )
	    {
		    if( S_ISDIR( buf.st_mode ))
		    {
			theme = g_malloc( sizeof( ThemeNode ));
			theme->name = g_strdup( dir->d_name );
			theme->path = filename;
			theme->skins = NULL;

			theme->skins = ScanSkinDir( filename, theme->skins );
			list = g_list_append( list, theme );
		    }
		    else	g_free( filename );
	    }
	    else	g_free( filename );
	}
  }
  else	fprintf( stderr, "Theme! Cannot open theme dir %s\n", dirname );

  return list; 
}
