/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"

static GtkWidget *url_window;
static void (*LoadDialogCallback)( char *url );
//
//
//

void mplayer_UrlSelect( GList *url_history, void (*_LoadDialogCallback)( char *url ))
{
  GtkCombo *combo;

  url_window = create_mplayer_urlselect_window();
  combo = GTK_COMBO( lookup_widget( url_window, "urlselect_combo" ));

  if( url_history )	gtk_combo_set_popdown_strings( combo, url_history );

  gtk_widget_show( url_window );
  LoadDialogCallback = _LoadDialogCallback;
}

//
// Needs to be non-static, needed by interface.c
//

void on_urlselect_ok_clicked( GtkButton *button, gpointer user_data )
{
  GtkCombo *combo;
  char *string;

  combo = GTK_COMBO( lookup_widget( url_window, "urlselect_combo" ));
  string = g_strdup( gtk_entry_get_text( GTK_ENTRY( combo->entry )));

  gtk_widget_destroy( url_window );
  LoadDialogCallback( string );
  g_free( string );
}
