/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// PushButton
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wPushButtonDraw( mptWidget *widget )
{
  mptPushButton *pb = (mptPushButton *) widget;

  if( !widget->visible )	return;

  gdk_draw_pixmap(	pb->sys.window, pb->sys.gc, pb->sys.pixmap,
			pb->sx + pb->shade * pb->pressed * pb->sys.width * ( pb->alignment == 0 ),
			pb->sy + pb->shade * pb->pressed * pb->sys.height * ( pb->alignment == 1 ),
			pb->sys.x, pb->sys.y,
			pb->sys.width, pb->sys.height );

}

//
// Button press callback
//

static int wPushButton_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptPushButton *pb = (mptPushButton *) widget;

  pb->pressed = 1;
  pb->sys.cbDraw( (mptWidget *)pb );
  mpint_RefreshTheme( pb->sys.theme );

  return 1;
}

//
// Button release callback
//

static int wPushButton_button_released( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptPushButton *pb = (mptPushButton *) widget;

  pb->pressed = 0;
  pb->sys.cbDraw( (mptWidget *)pb );
  mpint_RefreshTheme( pb->sys.theme );
  if( pb->sys.ReleaseCallback )	pb->sys.ReleaseCallback( 0 );

  return 1;
}

//
// Parse and create PushButton 
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptPushButton	*pb;

mptWidget *wPushButtonParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	pb = (mptPushButton *) g_malloc( sizeof( mptPushButton ));

	pb->sys.cbDraw = wPushButtonDraw;
	pb->sys.cbButtonPress = wPushButton_button_pressed;
	pb->sys.cbButtonRelease = wPushButton_button_released;
	pb->sys.cbMotion = NULL;
	pb->sys.Free = NULL;
	pb->pressed = 0;
	pb->alignment = 0;
	pb->shade = 1;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)pb ))	return NULL;
	return (mptWidget *) pb;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &pb->sys.x, &pb->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &pb->sys.width, &pb->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &pb->sx, &pb->sy );
	if( !strcasecmp( option, "Alignment" ))	ReadOrd( value, &pb->alignment );
	if( !strcasecmp( option, "Shade" ))	ReadOrd( value, &pb->shade );
  }

  return NULL;
}
