/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Pixmap
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wPixmapDraw( mptWidget *widget )
{
  mptPixmap *pm = (mptPixmap *) widget;

  if( !widget->visible )	return;

  gdk_draw_pixmap(	pm->sys.window,	pm->sys.gc, pm->sys.pixmap,
                        pm->sx, pm->sy,	pm->sys.x, pm->sys.y,
			pm->sys.width, pm->sys.height );
}

//
// Parse and create Pixmap
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptPixmap		*pm;

mptWidget *wPixmapParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	pm = (mptPixmap *) g_malloc( sizeof( mptPixmap ));

	pm->sys.cbDraw = wPixmapDraw;
	pm->sys.cbButtonPress = NULL;
	pm->sys.cbButtonRelease = NULL;
	pm->sys.cbMotion = NULL;
	pm->sys.Free = NULL;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)pm ))	return NULL;
	return (mptWidget *) pm;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &pm->sys.x, &pm->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &pm->sys.width, &pm->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &pm->sx, &pm->sy );
  }

  return NULL;
}
