/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Popup
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Prototypes
//

static int wPopup_create_window( mptPopup *pu );

//
// Draw callback
//

static void wPopupDraw( mptWidget *widget )
{
  mptPopup *pu = (mptPopup *) widget;
  int i;

  if( !widget->visible )	return;

  if( pu->pressed )
  {
	for( i = 0; i < pu->items; i++ )
	{
	    gdk_draw_pixmap( pu->window->window,
			    pu->window->style->fg_gc[ GTK_WIDGET_STATE( pu->window )],
			    pu->sys.pixmap,
			    pu->sx + ( i == pu->active ) * ( pu->sys.width + pu->delta ),
			    pu->sy + i * ( pu->orig_height + pu->delta ),
			    0, i * pu->orig_height,
			    pu->sys.width, pu->orig_height );
	}
  }
  else if( pu->downpop > -1 )
  {
	gdk_draw_pixmap( pu->sys.window, pu->sys.gc, pu->sys.pixmap,
			    pu->sx + pu->barwidth,
			    pu->sy + pu->downpop * ( pu->sys.height + pu->delta ),
			    pu->sys.x, pu->sys.y,
			    pu->sys.width - pu->barwidth, pu->sys.height );
  }
}

//
// Button press callback
//

static int wPopup_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptPopup *pu = (mptPopup *) widget;
  int x, y;

  pu->pressed = 1;
  pu->active = pu->items - 1;
  pu->orig_y = pu->sys.y;
  pu->orig_height = pu->sys.height;
  pu->sys.y -= ( pu->items - 1 ) * pu->sys.height;
  pu->sys.height *= pu->items;

  gtk_widget_show( pu->window );
  gdk_window_get_position( pu->sys.theme->window->window, &x, &y );
  gdk_window_move( pu->window->window, pu->sys.x + x - pu->barwidth, pu->sys.y + y );
  gdk_window_raise( pu->window->window );
  pu->sys.cbDraw( (mptWidget *)pu );
  mpint_RefreshTheme( pu->sys.theme );
  gdk_flush();

  return 1;
}

//
// Button release callback
//

static int wPopup_button_released( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptPopup *pu = (mptPopup *)widget;

//
// Button release from main window. Destroy popup.
//

  gtk_widget_hide( pu->window );

  pu->pressed = 0;
  pu->sys.y = pu->orig_y;
  pu->sys.height = pu->orig_height;

  return 1;
}

static int wPopup_motion( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{

//
// Motion events from the main window are not handled, as
// the popup widget creates it's own Gtk window
//

  return 1;
}


//
// Destroy window
//

static void wPopupFree( mptWidget *widget )
{
  mptPopup *pu = (mptPopup *)widget;

  gtk_widget_destroy( pu->window );
  g_free( pu );
}

//
// Parse and create Popup 
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptPopup		*pu;

mptWidget *wPopupParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	pu = (mptPopup *) g_malloc( sizeof( mptPopup ));

	pu->sys.cbDraw = wPopupDraw;
	pu->sys.cbButtonPress = wPopup_button_pressed;
	pu->sys.cbButtonRelease = wPopup_button_released;
	pu->sys.cbMotion = wPopup_motion;
	pu->sys.Free = wPopupFree;
	pu->pressed = 0;
	pu->active = 0;
	pu->delta = 0;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)pu ))	return NULL;
	wPopup_create_window( pu );
	return (mptWidget *) pu;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &pu->sys.x, &pu->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &pu->sys.width, &pu->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &pu->sx, &pu->sy );
	if( !strcasecmp( option, "Items" ))	ReadOrd( value, &pu->items );
	if( !strcasecmp( option, "Delta" ))	ReadOrd( value, &pu->delta );
	if( !strcasecmp( option, "DownPop" ))	ReadOrd( value, &pu->downpop );
	if( !strcasecmp( option, "BarWidth" ))	ReadOrd( value, &pu->barwidth );
  }

  return NULL;
}

//
// Gtk Events
//

static gint on_expose_event( GtkWidget *widget, GdkEventButton *event, gpointer data )
{
  ((mptWidget *)data)->cbDraw( (mptWidget *)data );
  return TRUE;
}

//
// Button release
//

static gint on_button_release_event( GtkWidget *widget, GdkEventButton *event, gpointer data )
{
  mptPopup *pu = (mptPopup *) data;

  gtk_widget_hide( pu->window );

  pu->pressed = 0;
  pu->sys.y = pu->orig_y;
  pu->sys.height = pu->orig_height;

  if( pu->sys.ReleaseCallback )	pu->sys.ReleaseCallback( pu->active );

  return TRUE;
}

//
// Motion
//

static gint on_motion_notify_event( GtkWidget *widget, GdkEventButton *event, gpointer data )
{
  mptPopup *pu = (mptPopup *) data;

  if( !pu->pressed )	return 1;

  pu->active = event->y / pu->orig_height;
  pu->sys.cbDraw( (mptWidget *)pu );
  mpint_RefreshTheme( pu->sys.theme );

  return TRUE;
}

//
// Gtk Popup window
//

static int wPopup_create_window( mptPopup *pu )
{
  pu->window = gtk_window_new( GTK_WINDOW_POPUP );

  // * Allow painting in widget
  gtk_widget_set_app_paintable( GTK_WIDGET( pu->window ), TRUE );

  // * Window Size
  gtk_widget_set_usize( GTK_WIDGET( pu->window ), pu->sys.width, pu->items * pu->sys.height );

  // * We want to be notified about...
  gtk_widget_set_events( GTK_WIDGET( pu->window ),  GDK_EXPOSURE_MASK |
						    GDK_BUTTON_RELEASE_MASK |
						    GDK_POINTER_MOTION_MASK );

  //
  //  Connect signals
  //

  gtk_signal_connect( GTK_OBJECT( pu->window ), "expose_event",
			    GTK_SIGNAL_FUNC( on_expose_event ), pu );

  gtk_signal_connect( GTK_OBJECT( pu->window ), "button_release_event",
			    GTK_SIGNAL_FUNC( on_button_release_event ), pu );

  gtk_signal_connect( GTK_OBJECT( pu->window ), "motion_notify_event",
			    GTK_SIGNAL_FUNC( on_motion_notify_event ), pu );

  return 1;
}
