/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Slider
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Horizontal
//

//
// Draw callback
//

static void wHSliderDraw( mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;

  if( !widget->visible )	return;

  gdk_draw_pixmap(	hs->sys.window,	hs->sys.gc, hs->sys.pixmap,
			hs->FrameXOffset, hs->FrameYOffset +
			( hs->position * hs->frames / ( hs->max + 1 ) * ( hs->sys.height + hs->FrameDelta )),
			hs->sys.x, hs->sys.y,
			hs->sys.width, hs->sys.height);

  gdk_draw_pixmap(	hs->sys.window, hs->sys.gc, hs->sys.pixmap,
			hs->sx + ( hs->knoborder ? !hs->pressed : hs->pressed ) * ( hs->KnobWidth + hs->KnobDelta ), hs->sy,
			hs->sys.x + hs->position,
			hs->sys.y + (( hs->sys.height - hs->KnobHeight ) >> 1 ),
			hs->KnobWidth, hs->KnobHeight );
}

//
// Button press callback
//

static int wHSlider_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;
  int dx;

  hs->pressed = 1;
  dx = event->x - hs->sys.x;

  if(( dx >= hs->position ) && ( dx < ( hs->position + hs->KnobWidth )))
  {
	hs->pressed_ord = dx - hs->position;
  }
  else
  {
	hs->position = dx - ( hs->KnobWidth / 2 );
	hs->pressed_ord = hs->KnobWidth / 2;

	if( hs->position < 0 )	hs->position = 0;
	if( hs->position > hs->max )	hs->position = hs->max;
  }

  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );
  if( hs->sys.ChangeCallback )	hs->sys.ChangeCallback( hs->position * 100 / hs->max );

  return 1;
}

//
// Motion callback
//

static int wHSlider_motion( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;
  gint dx;

  if( !hs->pressed )	return 1;

  dx = event->x - hs->sys.x;
  hs->position = dx - hs->pressed_ord;

  if( hs->position < 0 )	hs->position = 0;
  if( hs->position > hs->max )	hs->position = hs->max;
  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );
  if( hs->sys.ChangeCallback )	hs->sys.ChangeCallback( hs->position * 100 / hs->max );

  return 1;
}

//
// Vertical
//

//
// Draw callback
//

static void wVSliderDraw( mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;

  if( !widget->visible )	return;

  gdk_draw_pixmap(	hs->sys.window, hs->sys.gc, hs->sys.pixmap,
			hs->FrameXOffset + ( hs->position * hs->frames / 
			( hs->max + 1 ) * ( hs->sys.width + hs->FrameDelta )),
			hs->FrameYOffset, hs->sys.x, hs->sys.y,
			hs->sys.width, hs->sys.height );

  gdk_draw_pixmap(	hs->sys.window, hs->sys.gc, hs->sys.pixmap,
			hs->sx, hs->sy + ( hs->knoborder ? !hs->pressed : hs->pressed ) * ( hs->KnobHeight + hs->KnobDelta ),
			hs->sys.x + (( hs->sys.width - hs->KnobWidth ) >> 1 ),
			hs->sys.y + hs->position,
			hs->KnobWidth, hs->KnobHeight );
}

//
// Button press callback
//

static int wVSlider_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;
  int dy;

  hs->pressed = 1;
  dy = event->y - hs->sys.y;

  if(( dy >= hs->position ) && ( dy < ( hs->position + hs->KnobWidth )))
  {
	hs->pressed_ord = dy - hs->position;
  }
  else
  {
	hs->position = dy - ( hs->KnobWidth / 2 );
	hs->pressed_ord = hs->KnobWidth / 2;

	if( hs->position < 0 )	hs->position = 0;
	if( hs->position > hs->max )	hs->position = hs->max;
  }

  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );
  if( hs->sys.ChangeCallback )	hs->sys.ChangeCallback( hs->position * 100 / hs->max );

  return 1;
}

//
// Motion callback
//

static int wVSlider_motion( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;
  gint dy;

  if( !hs->pressed )	return 1;

  dy = event->y - hs->sys.y;
  hs->position = dy - hs->pressed_ord;

  if( hs->position < 0 )	hs->position = 0;
  if( hs->position > hs->max )	hs->position = hs->max;
  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );
  if( hs->sys.ChangeCallback )	hs->sys.ChangeCallback( hs->position * 100 / hs->max );

  return 1;
}

//
// Button release callback, ( HSlider and VSlider )
//

static int wSlider_button_released( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptSlider *hs = (mptSlider *) widget;

  if( !hs->pressed )	return 1;

  hs->pressed = 0;
  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );
  if( hs->sys.ReleaseCallback )	hs->sys.ReleaseCallback( hs->position * 100 / hs->max  );

  return 1;
}

//
// Parse and create Slider
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptSlider	*hs;

mptWidget *wSliderParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	hs = (mptSlider *) g_malloc( sizeof( mptSlider ));

	hs->sys.Free = NULL;
	hs->pressed = 0;
	hs->type = 0;
	hs->knoborder = 0;
	hs->min = 0;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)hs ))	return NULL;
	hs->position = 0;
	if( hs->type == 0 )
	{
		hs->max = hs->sys.width - hs->KnobWidth;
		hs->sys.cbDraw = wHSliderDraw;
		hs->sys.cbButtonPress = wHSlider_button_pressed;
		hs->sys.cbButtonRelease = wSlider_button_released;
		hs->sys.cbMotion = wHSlider_motion;
	}
	else
	{
		hs->max = hs->sys.height - hs->KnobHeight;
		hs->sys.cbDraw = wVSliderDraw;
		hs->sys.cbButtonPress = wVSlider_button_pressed;
		hs->sys.cbButtonRelease = wSlider_button_released;
		hs->sys.cbMotion = wVSlider_motion;
	}
	return (mptWidget *)hs;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &hs->sys.x, &hs->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &hs->sys.width, &hs->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "KnobOffset" ))	ReadCoord( value, &hs->sx, &hs->sy );
	if( !strcasecmp( option, "KnobSize" ))	ReadCoord( value, &hs->KnobWidth, &hs->KnobHeight );
	if( !strcasecmp( option, "KnobDelta" ))	ReadOrd( value, &hs->KnobDelta );
	if( !strcasecmp( option, "FrameOffset" ))	ReadCoord( value, &hs->FrameXOffset, &hs->FrameYOffset );
	if( !strcasecmp( option, "FrameDelta" ))	ReadOrd( value, &hs->FrameDelta );
	if( !strcasecmp( option, "Frames" ))	ReadOrd( value, &hs->frames );
	if( !strcasecmp( option, "KnobOrder" ))	ReadOrd( value, &hs->knoborder );
	if( !strcasecmp( option, "Type" ))	ReadOrd( value, &hs->type );

  }

  return NULL;
}

//
// Set slider value
//

int mpwSliderSetValue( mptSlider *hs, int value )
{
  value = value * hs->max / 100;

  if(( value == hs->position ) || hs->pressed )	return 1;
  hs->position = value;

  if( hs->position < hs->min )	hs->position = hs->min;
  if( hs->position > hs->max )	hs->position = hs->max;
  hs->sys.cbDraw( (mptWidget *)hs );
  mpint_RefreshTheme( hs->sys.theme );

  return 1;
}

//
// Get slider value
//

int mpwSliderGetValue( mptSlider *hs )
{
  return hs->position * 100 / hs->max;
}
