/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Status
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wStatusDraw( mptWidget *widget )
{
  int x;
  mptStatus *st = (mptStatus *) widget;

  if( !widget->visible )	return;

  if( st->Type == 0 )
  {
    gdk_draw_pixmap(	st->sys.window,	st->sys.gc, st->sys.pixmap,
			st->sx + ( st->sys.width + st->delta ) * st->status * ( st->alignment == 0 ),
			st->sy + ( st->sys.height + st->delta ) * st->status * ( st->alignment == 1 ),
			st->sys.x, st->sys.y, st->sys.width, st->sys.height );
  }

  if( st->Type == 1 )
  {
	for( x = 0; x < st->states; x++ )
	{
	    gdk_draw_pixmap(	st->sys.window,	st->sys.gc, st->sys.pixmap,
				st->sx + ( st->sys.width + st->delta ) * x * ( st->alignment == 0 ),
				st->sy + ( st->sys.height + st->delta ) * x * ( st->alignment == 1 ) + ( x != st->status ? st->sys.height : 0 ),
				st->sys.x + st->sys.width * x * ( st->Type == 1 ),
				st->sys.y + st->sys.height * x * ( st->Type == 2 ),
				st->sys.width, st->sys.height );
	}
  }
}

//
// Parse and create Status
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptStatus		*st;

mptWidget *wStatusParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	st = (mptStatus *) g_malloc( sizeof( mptStatus ));

	st->sys.cbDraw = wStatusDraw;
	st->sys.cbButtonPress = NULL;
	st->sys.cbButtonRelease = NULL;
	st->sys.cbMotion = NULL;
	st->sys.Free = NULL;
	st->status = 0;
	st->states = 0;
	st->delta = 0;
	st->alignment = 0;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)st ))	return NULL;
	return (mptWidget *) st;
  }

  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &st->sys.x, &st->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &st->sys.width, &st->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &st->sx, &st->sy );
	if( !strcasecmp( option, "Type" ))	ReadOrd( value, &st->Type );
	if( !strcasecmp( option, "States" ))	ReadOrd( value, &st->states );
	if( !strcasecmp( option, "Delta" ))	ReadOrd( value, &st->delta );
	if( !strcasecmp( option, "Alignment" ))	ReadOrd( value, &st->alignment );
  }

  return NULL;
}

int mpwStatusSetStatus( mptStatus *st, int status )
{
  st->status = status;
  st->sys.cbDraw( (mptWidget *)st );
  mpint_RefreshTheme( st->sys.theme );

  return 1;
}

int mpwStatusGetStatus( mptStatus *st )
{
  return st->status;
}
