/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2001 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * Preferences window
 */

#include <gtk/gtk.h>

#include <libmplayer/support.h>
#include "interface.h"

#include <libxmmplay/xmmplay.h>
#include <libxmm/libxmm.h>

/*
 * Global data
 */

static GtkWidget	*pref_window;

static XMM_List		*pref_pInputList;
static XMM_List		*pref_pGraphList;
static XMM_List		*pref_pSoundList;

static XMM_PluginGraph	*sGraph;
static XMM_PluginSound	*sSound;

static XMM_Play		*xmmplay;

/*
 * Prototypes
 */

void on_pref_input_clist_select_row( GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data );
void on_pref_input_clist_unselect_row( GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data );
void on_pref_input_config_clicked( GtkButton *button, gpointer user_data );
void on_pref_input_about_clicked( GtkButton *button, gpointer user_data );

void on_pref_apply_clicked( GtkButton *button, gpointer user_data );
void on_pref_cancel_clicked( GtkButton *button, gpointer user_data );
void on_pref_ok_clicked( GtkButton *button, gpointer user_data );

static void on_pref_graph_activate( GtkWidget *widget, XMM_PluginGraph *graph );
static void on_pref_sound_activate( GtkWidget *widget, XMM_PluginSound *sound );

/*
 * Public code
 */

void mp_PrefWin( XMM_Play *_xmmplay )
{
  GtkWidget		*pref_input_clist, *pref_graph_optionmenu;
  GtkWidget		*pref_sound_optionmenu, *item, *menu;
  XMM_List		*le;
  XMM_PluginGraph	*cGraph;
  XMM_PluginSound	*cSound;
  int			history, i;

  xmmplay = _xmmplay;

  pref_pInputList = xmm_PluginRegisterDir( LIBDIR "Plugins/Input", XMM_PLUGIN_TYPE_INPUT );
  pref_pGraphList = xmm_PluginRegisterDir( LIBDIR "Plugins/Graph", XMM_PLUGIN_TYPE_GRAPH );
  pref_pSoundList = xmm_PluginRegisterDir( LIBDIR "Plugins/Sound", XMM_PLUGIN_TYPE_SOUND );

  pref_window = create_pref_window ();

  /*
   * Input clist
   */
  pref_input_clist = lookup_widget( pref_window, "pref_input_clist" );

  for( le = pref_pInputList; le; le = le->next )
  {
	gchar *temp[1];
	guint row;
		
	temp[0] = ((XMM_Plugin *)le->data)->Name;

	row = gtk_clist_append( GTK_CLIST( pref_input_clist ), temp );
	gtk_clist_set_selectable( GTK_CLIST( pref_input_clist ), row, TRUE );
	gtk_clist_set_row_data( GTK_CLIST( pref_input_clist ), row, le->data );
  }

  gtk_clist_columns_autosize( GTK_CLIST( pref_input_clist ));
  gtk_clist_set_column_justification( GTK_CLIST( pref_input_clist ), 0, GTK_JUSTIFY_LEFT );

  /*
   * Graph option_menu
   */
  pref_graph_optionmenu = lookup_widget( pref_window, "pref_graph_optionmenu" );

  menu = gtk_menu_new();

  cGraph = pref_pGraphList->data;
xmm_logging( 1, "gl = %p\n", pref_pGraphList );
  for( history = 0, i = 0, le = pref_pGraphList; le; le = le->next, i++ )
  {
	xmm_logging( 1, "file: %s set: %s\n", ((XMM_Plugin *)le->data)->Filename, xmm_AcGraphPluginName( XMMPLAY_2XMM(xmmplay), NULL ));

	if( !strcmp(((XMM_Plugin *)le->data)->Filename, xmm_AcGraphPluginName( XMMPLAY_2XMM(xmmplay), NULL )))
	{
		history = i;
		cGraph = le->data;
	}
	item = gtk_menu_item_new_with_label( ((XMM_Plugin *)le->data)->Name );
	gtk_signal_connect( GTK_OBJECT( item ), "activate", GTK_SIGNAL_FUNC( on_pref_graph_activate ), le->data );
	gtk_widget_show( item );
	gtk_menu_append( GTK_MENU( menu ), item );
  }

  gtk_option_menu_set_menu( GTK_OPTION_MENU( pref_graph_optionmenu ), menu );
  gtk_option_menu_set_history( GTK_OPTION_MENU( pref_graph_optionmenu ), history );
  on_pref_graph_activate( NULL, cGraph );

  /*
   * Sound option_menu
   */
  pref_sound_optionmenu = lookup_widget( pref_window, "pref_sound_optionmenu" );

  menu = gtk_menu_new();

  cSound = pref_pSoundList->data;
  for( history = 0, i = 0, le = pref_pSoundList; le; le = le->next, i++ )
  {
	if( !strcmp(((XMM_Plugin *)le->data)->Filename, xmm_AcSoundPluginName( XMMPLAY_2XMM(xmmplay), NULL )))
	{
		history = i;
		cSound = le->data;
	}
	item = gtk_menu_item_new_with_label( ((XMM_Plugin *)le->data)->Name );
	gtk_signal_connect( GTK_OBJECT( item ), "activate", GTK_SIGNAL_FUNC( on_pref_sound_activate ), le->data );
	gtk_widget_show( item );
	gtk_menu_append( GTK_MENU( menu ), item );
  }
  gtk_option_menu_set_menu( GTK_OPTION_MENU( pref_sound_optionmenu ), menu );
  gtk_option_menu_set_history( GTK_OPTION_MENU( pref_sound_optionmenu ), history );
  on_pref_sound_activate( NULL, cSound );

  gtk_widget_show( pref_window );
}

/*
 * Public code ( needed by interface.c )
 */

void on_pref_input_clist_select_row( GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data )
{
  XMM_PluginInput *input = ((XMM_PluginInput *)gtk_clist_get_row_data( clist, row ));

  if( clist->selection )
  {
	if( xmm_InputControl( input, XMM_CTLDLG_QUERY, XMM_GTKDLG_CONFIG, NULL ) == XMM_CTLRET_TRUE )
	    gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_config" ), 1 );
	else
	    gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_config" ), 0 );

	if( xmm_InputControl( input, XMM_CTLDLG_QUERY, XMM_GTKDLG_ABOUT, NULL ) == XMM_CTLRET_TRUE )
	    gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_about" ), 1 );
	else
	    gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_about" ), 0 );
  }
  else
  {
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_config" ), 0 );
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( user_data ), "pref_input_about" ), 0 );
  }
}

void on_pref_input_clist_unselect_row( GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data )
{
  g_print( "Row %i unselected\n", row );
}

void on_pref_input_config_clicked( GtkButton *button, gpointer user_data )
{
  XMM_PluginInput	*input;
  GtkCList		*clist;

  clist = (GtkCList *)lookup_widget( GTK_WIDGET( user_data ), "pref_input_clist" );
  input = ((XMM_PluginInput *)gtk_clist_get_row_data( clist, (int)clist->selection->data ));
  xmm_InputControl( input, XMM_CTLDLG_DISPLAY, XMM_GTKDLG_CONFIG, NULL );
}

void on_pref_input_about_clicked( GtkButton *button, gpointer user_data )
{
  XMM_PluginInput	*input;
  GtkCList		*clist;

  clist = (GtkCList *)lookup_widget( GTK_WIDGET( user_data ), "pref_input_clist" );
  input = ((XMM_PluginInput *)gtk_clist_get_row_data( clist, (int)clist->selection->data ));
  xmm_InputControl( input, XMM_CTLDLG_DISPLAY, XMM_GTKDLG_ABOUT, NULL );
}

/*
 * Main pref dialogue event callbacks
 */

void on_pref_apply_clicked( GtkButton *button, gpointer user_data )
{
  xmm_AcGraphPluginName( XMMPLAY_2XMM(xmmplay), sGraph->sys.Filename );
  xmm_AcSoundPluginName( XMMPLAY_2XMM(xmmplay), sSound->sys.Filename );
}

void on_pref_cancel_clicked( GtkButton *button, gpointer user_data )
{
  xmm_PluginRemoveList( pref_pInputList );
  xmm_PluginRemoveList( pref_pGraphList );
  xmm_PluginRemoveList( pref_pSoundList );

  gtk_widget_destroy( GTK_WIDGET( user_data ));
}

void on_pref_ok_clicked( GtkButton *button, gpointer user_data )
{
  on_pref_apply_clicked( button, user_data );
  on_pref_cancel_clicked( button, user_data );
}

/*
 * Private event callbacks
 */

static void on_pref_graph_activate( GtkWidget *widget, XMM_PluginGraph *graph )
{
  sGraph = graph;

  if( graph == NULL )
  {
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_config" ), 0 );
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_about" ), 0 );
	return;
  }

  g_print( "Graph Plugin Activated: %s\n", graph->sys.Name );

  if( xmm_GraphControl( graph, XMM_CTLDLG_QUERY, XMM_GTKDLG_CONFIG, NULL ) == XMM_CTLRET_TRUE )
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_config" ), 1 );
  else	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_config" ), 0 );

  if( xmm_GraphControl( graph, XMM_CTLDLG_QUERY, XMM_GTKDLG_ABOUT, NULL ) == XMM_CTLRET_TRUE )
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_about" ), 1 );
  else	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_graph_about" ), 0 );
}

static void on_pref_sound_activate( GtkWidget *widget, XMM_PluginSound *sound )
{
  sSound = sound;

  if( sound == NULL )
  {
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_config" ), 0 );
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_about" ), 0 );
	return;
  }

  g_print( "Sound Plugin Activated: %s\n", sound->sys.Name );

  if( xmm_SoundControl( sound, XMM_CTLDLG_QUERY, XMM_GTKDLG_CONFIG, NULL ) == XMM_CTLRET_TRUE )
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_config" ), 1 );
  else	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_config" ), 0 );

  if( xmm_SoundControl( sound, XMM_CTLDLG_QUERY, XMM_GTKDLG_ABOUT, NULL ) == XMM_CTLRET_TRUE )
	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_about" ), 1 );
  else	gtk_widget_set_sensitive( lookup_widget( GTK_WIDGET( pref_window ), "pref_sound_about" ), 0 );
}
