/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_mplayerwidgets_h
#define INC_mplayerwidgets_h

#include <gtk/gtk.h>
#include <libmplayer/mplayertypes.h>

#ifdef __cplusplus
extern "C"
{
#endif

//
// Draw Area
//

typedef struct mpsDrawArea
{
    mptWidget		sys;
    unsigned char	*idxdata;
    GdkRgbCmap		*cmap;
} mptDrawArea;

	// Set content of drawing aread
void	mpwDrawAreaSetData( mptDrawArea *da, unsigned char *idxdata );

//
// List
//

	// Doubleclick event
#define	MPLAYER_LIST_DOUBLE_CLICK	32768

typedef struct mpsListEntry
{
    char	*text;
    int		selected;
} mptListEntry;

typedef struct mpsList
{
    mptWidget	sys;
    GdkColor	color, color_h;
    GdkColor	bgcolor, bgcolor_h;
    int		fheight;
    int		active;
    int		selected;
    int		pressed;
    int		start;
    GList	*elist;
} mptList;

	// Append entry
int	mpwListAddEntry( mptList *list, char *text );
	// Clear list
void	mpwListClear( mptList *list );
	// Set active entry
void	mpwListSetActive( mptList *list, int active );
	// Remove entry
void	mpwListRemove( mptList *list, int num );
	// Get select state of entry
int	mpwListSelectionGet( mptList *list, int nth );
	// Set select state of entry
int	mpwListSelectionSet( mptList *list, int nth, int flag );

//
// Menu
//

typedef struct mpsMenu
{
    mptWidget	sys;
    int		pressed;
    int		selected;
    int		items;
    int		sx;
    int		sy;
    int		WinAmp;
} mptMenu;

//
// Number
//

typedef struct mpsNumber
{
    mptWidget	sys;
    int		sx;
    int		sy;
    int		digits;
    int		value;
} mptNumber;

	// Set value
void	mpwNumberSetValue( mptNumber *num, int value );

//
// Push Button
//

typedef struct mpsPushButton
{
    mptWidget	sys;
    int		sx;
    int		sy;
    int		pressed;
    int		alignment;
    int		shade;
} mptPushButton;

//
// Toggle Button
//

typedef struct mpsToggleButton
{
    mptWidget	sys;
    int		alignment;
    int		sx;
    int		sy;
    int		pressed;
    int		toggled;
} mptToggleButton;

	// Set state of the button
int	mpwToggleButtonState( mptToggleButton *tb, int state );

//
// Pixmap
//

typedef struct mpsPixmap
{
    mptWidget	sys;
    int		sx;
    int		sy;
} mptPixmap;

//
// Types
//

typedef struct mpsPopup
{
    mptWidget	sys;
    int		sx;
    int		sy;
    int		items;
    int		pressed;
    int		delta;
    int		barwidth;
    int		active;
    int		downpop;
    int		orig_y;
    int		orig_height;
    GtkWidget	*window;
} mptPopup;

//
// Slider
//

typedef struct _mpsSlider
{
    mptWidget	sys;
    int		pressed;
    int		position;
    int		frames;
    int		pressed_ord;
    int		type;
// Knob
    int		sx;
    int		sy;
    int		KnobWidth;
    int		KnobHeight;
    int		KnobDelta;
    int		min;
    int		max;
// Frame
    int		FrameXOffset;
    int		FrameYOffset;
    int		FrameDelta;
    int		knoborder;
} mptSlider;

	// Set the slider value ( range: 0 - 100 )
int	mpwSliderSetValue( mptSlider *hs, int value );

	// Get slider value
int	mpwSliderGetValue( mptSlider *hs );

//
// Status
//

typedef struct mpsStatus
{
    mptWidget	sys;
    int		sx;
    int		sy;
    int		Type;
    int		states;
    int		status;
    int		delta;
    int		alignment;
} mptStatus;

	// Set state
int	mpwStatusSetStatus( mptStatus *st, int status );
	// Get state
int	mpwStatusGetStatus( mptStatus *st );

//
// Textbox
//

typedef struct mpsTextBox
{
    mptWidget	sys;
    int		pressed;
    int		sx;
    int		sy;
    int		scroll;
    int		FontWidth;
    int		FontHeight;
    int		WinAmp;
// Private
    char	*Text;
    int		TextOffset;
    GdkPixmap	*Pixmap;
    int		PixmapWidth;
    int		drag_start;
    int		drag_x;
    gint	Timer;
} mptTextBox;

	// Set text
int	mpwTextBoxSetText( mptTextBox *tb, char *text );

#ifdef __cplusplus
}
#endif

#endif
