/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_parser_h
#define INC_parser_h

#include <libmplayer/mplayerwidgets.h>

//
// Definitions
//

#define	WIDGET_START	1
#define	WIDGET_STOP	2
#define	WIDGET_OPTION	3

//
// Prototypes
//

int ReadCoord( char *string, int *x1, int *x2 );
int ReadOrd( char *string, int *x );
int ReadString( char *string, char *dest );
int ReadArray( char *string, int *x, int max );
int LookupWidget( mptTheme *theme, char *name, char *pixmapfile, mptWidget *sw );

//
// Widget parser
//

mptWidget *wDrawAreaParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wListParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wMenuParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wNumberParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wPushButtonParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wPixmapParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wPopupParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wSliderParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wStatusParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wToggleButtonParse( mptTheme *theme, int mode, char *option, char *value );
mptWidget *wTextBoxParse( mptTheme *theme, int mode, char *option, char *value );

#endif
