/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// DrawArea
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wDrawAreaDraw( mptWidget *widget )
{
  mptDrawArea *da = (mptDrawArea *) widget;

  if( !widget->visible )	return;

  if( da->idxdata == NULL )	return;

  gdk_draw_indexed_image(   da->sys.window, da->sys.gc,
			    da->sys.x, da->sys.y, da->sys.width, da->sys.height,
			    GDK_RGB_DITHER_NORMAL,
			    da->idxdata, da->sys.width, da->cmap );
}

//
// Free drawarea stuff
//

static void wDrawAreaFree( mptWidget *widget )
{
  mptDrawArea *da = (mptDrawArea *)widget;

  gdk_rgb_cmap_free( da->cmap );
}

//
// Parse and create DrawArea
//

#include <string.h>
#include "parser.h"

static char		name[256];
static mptDrawArea	*da;
static guint32		aColor[24];

mptWidget *wDrawAreaParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	da = (mptDrawArea *) g_malloc( sizeof( mptDrawArea ));

	da->sys.cbDraw = wDrawAreaDraw;
	da->sys.cbButtonPress = NULL;
	da->sys.cbButtonRelease = NULL;
	da->sys.cbMotion = NULL;
	da->sys.Free = wDrawAreaFree;
	da->idxdata = NULL;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, "", (mptWidget *)da ))	return NULL;
	da->cmap = gdk_rgb_cmap_new( aColor, 24 );
	return (mptWidget *) da;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &da->sys.x, &da->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &da->sys.width, &da->sys.height );
	if( !strcasecmp( option, "Colors" ))	ReadArray( value, aColor, 24 );
  }

  return NULL;
}

void mpwDrawAreaSetData( mptDrawArea *da, unsigned char *idxdata )
{
  da->idxdata = idxdata;
  da->sys.cbDraw( (mptWidget *)da );
  mpint_RefreshTheme( da->sys.theme );
}
