/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Menu
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wMenuDraw( mptWidget *widget )
{
  mptMenu *m = (mptMenu *) widget;

  if( !widget->visible )	return;

  if( m->WinAmp )
  {
    if( m->selected == -1 )
    {
	gdk_draw_pixmap( m->sys.window, m->sys.gc, m->sys.pixmap,
			    m->sx, m->sy,
			    m->sys.x, m->sys.y, m->sys.width, m->sys.height );
    }
    else
    {
	gdk_draw_pixmap( m->sys.window, m->sys.gc,
			    m->sys.pixmap, m->sx + m->selected * m->sys.width,
			    m->sy + m->sys.height + 1,
			    m->sys.x, m->sys.y, m->sys.width, m->sys.height );
    }
  }
  else
  {
	gdk_draw_pixmap( m->sys.window, m->sys.gc, m->sys.pixmap,
			    m->sx + ( m->selected + 1 ) * m->sys.width, m->sy,
			    m->sys.x, m->sys.y, m->sys.width, m->sys.height );
  }
}

//
// Button press callback
//

static int wMenu_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptMenu *m = (mptMenu *) widget;

  m->pressed = 1;
  m->selected = ( event->y - m->sys.y ) * m->items / m->sys.height;
  m->sys.cbDraw( (mptWidget *)m );
  mpint_RefreshTheme( m->sys.theme );
  return 1;
}

//
// Button release callback
//

static int wMenu_button_released( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptMenu *m = (mptMenu *) widget;

  if( !m->pressed )	return 1;
  m->pressed = 0;
  m->selected = -1;
  m->sys.cbDraw( (mptWidget *)m );
  mpint_RefreshTheme( m->sys.theme );

  return 1;
}

//
// Motion callback
//

static int wMenu_motion( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptMenu *m = (mptMenu *) widget;

  if( !m->pressed )	return 1;

  m->selected = ( event->y - m->sys.y ) * m->items / m->sys.height;
  m->sys.cbDraw( (mptWidget *)m );
  mpint_RefreshTheme( m->sys.theme );

  return 1;
}

//
// Parse and create Menu
//

#include <string.h>
#include <ctype.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptMenu		*m;

mptWidget *wMenuParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	m = (mptMenu *) g_malloc( sizeof( mptMenu ));

	m->sys.cbDraw = wMenuDraw;
	m->sys.cbButtonPress = wMenu_button_pressed;
	m->sys.cbButtonRelease = wMenu_button_released;
	m->sys.cbMotion = wMenu_motion;
	m->sys.Free = NULL;
	m->pressed = 0;
	m->selected = -1;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)m ))	return NULL;
	return (mptWidget *) m;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &m->sys.x, &m->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &m->sys.width, &m->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &m->sx, &m->sy );
	if( !strcasecmp( option, "Items" ))	ReadOrd( value, &m->items );
	if( !strcasecmp( option, "WinAmp" ))	ReadOrd( value, &m->WinAmp );
  }

  return NULL;
}
