/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// Number
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wNumberDraw( mptWidget *widget )
{
  int x, divi, remi;
  mptNumber *num = (mptNumber *) widget;

  if( !widget->visible )	return;

  for( x = 1, divi = 1; x < num->digits; x++ )	divi = divi * 10;

  for( x = 0, remi = num->value; x < num->digits; x++ )
  {
    gdk_draw_pixmap(	num->sys.window, num->sys.gc, num->sys.pixmap,
			num->sx + ( remi / divi ) * num->sys.width, num->sy,
			num->sys.x + x * ( num->sys.width + 2 ), num->sys.y,
			num->sys.width, num->sys.height );

    remi %= divi;
    divi /= 10;
  }
}

//
// Parse and create Number 
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptNumber		*num;

mptWidget *wNumberParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	num = (mptNumber *) g_malloc( sizeof( mptNumber ));

	num->sys.cbDraw = wNumberDraw;
	num->sys.cbButtonPress = NULL;
	num->sys.cbButtonRelease = NULL;
	num->sys.cbMotion = NULL;
	num->sys.Free = NULL;
	num->value = 0;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)num ))	return NULL;
	return (mptWidget *) num;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &num->sys.x, &num->sys.y );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &num->sx, &num->sy );
	if( !strcasecmp( option, "FontSize" ))	ReadCoord( value, &num->sys.width, &num->sys.height );
	if( !strcasecmp( option, "Digits" ))	ReadOrd( value, &num->digits );
  }

  return NULL;
}

//
// Set Number
//

void mpwNumberSetValue( mptNumber *num, int value )
{
  if( num->value == value )	return;
  num->value = value;
  num->sys.cbDraw( (mptWidget *)num );
  mpint_RefreshTheme( num->sys.theme );
}
