/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//
// ToggleButton
//

#include <gtk/gtk.h>
#include <libmplayer/mplayerwidgets.h>
#include "gtkwin.h"

//
// Draw callback
//

static void wToggleButtonDraw( mptWidget *widget )
{
  mptToggleButton *tb = (mptToggleButton *) widget;

  if( !widget->visible )	return;

  gdk_draw_pixmap(	tb->sys.window,	tb->sys.gc, tb->sys.pixmap,
			tb->sx + ( tb->pressed | tb->toggled ) * tb->sys.width * ( tb->alignment == 0 ),
			tb->sy + ( tb->pressed | tb->toggled ) * tb->sys.height * ( tb->alignment == 1 ),
			tb->sys.x, tb->sys.y,
			tb->sys.width, tb->sys.height );
}

//
// Button press callback
//

static int wToggleButton_button_pressed( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptToggleButton *tb = (mptToggleButton *) widget;

  tb->pressed = 1;
  tb->sys.cbDraw( (mptWidget *)tb );
  mpint_RefreshTheme( tb->sys.theme );

  return 1;
}

//
// Button release callback
//

static int wToggleButton_button_released( GtkWidget *gtkwidget, GdkEventButton *event, mptWidget *widget )
{
  mptToggleButton *tb = (mptToggleButton *) widget;

  tb->pressed = 0;
  if( tb->toggled )	tb->toggled = 0;
  else	tb->toggled = 2;

  tb->sys.cbDraw( (mptWidget *)tb );
  mpint_RefreshTheme( tb->sys.theme );
  if( tb->sys.ReleaseCallback )	tb->sys.ReleaseCallback( 0 );

  return 1;
}

//
// Parse and create ToggleButton 
//

#include <string.h>
#include "parser.h"

static char		name[256];
static char		pixmapfile[256];
static mptToggleButton	*tb;

mptWidget *wToggleButtonParse( mptTheme *theme, int mode, char *option, char *value )
{
  if( mode == WIDGET_START )
  {
	tb = (mptToggleButton *) g_malloc( sizeof( mptToggleButton ));

	tb->sys.cbDraw = wToggleButtonDraw;
	tb->sys.cbButtonPress = wToggleButton_button_pressed;
	tb->sys.cbButtonRelease = wToggleButton_button_released;
	tb->sys.cbMotion = NULL;
	tb->sys.Free = NULL;
	tb->pressed = 0;
	tb->toggled = 0;
	tb->alignment = 0;

	if( !ReadString( option, name ))	strcpy( name, option );
  }

  if( mode == WIDGET_STOP )
  {
	if( !LookupWidget( theme, name, pixmapfile, (mptWidget *)tb ))	return NULL;
	return (mptWidget *) tb;
  }
  if( mode == WIDGET_OPTION )
  {
	if( !strcasecmp( option, "Position" ))	ReadCoord( value, &tb->sys.x, &tb->sys.y );
	if( !strcasecmp( option, "Size" ))	ReadCoord( value, &tb->sys.width, &tb->sys.height );
	if( !strcasecmp( option, "Filename" ))	ReadString( value, pixmapfile );
	if( !strcasecmp( option, "Offset" ))	ReadCoord( value, &tb->sx, &tb->sy );
	if( !strcasecmp( option, "Alignment" ))	ReadOrd( value, &tb->alignment );
  }

  return NULL;
}

//
// Set button state
//

int mpwToggleButtonState( mptToggleButton *tb, int state )
{
  if( state > 0 )	tb->toggled = 2;
  else if( state == 0 )	tb->toggled = 0;

  if( state != -1 )		// Get state
  {
	tb->sys.cbDraw( (mptWidget *)tb );
	mpint_RefreshTheme( tb->sys.theme );
  }

  return ( tb->toggled == 2 );
}
