/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include <gtk/gtk.h>

#include <libxmm/libxmm.h>
#include <libxmm/util/config.h>
#include <libxmm/util/utils.h>
#include <libxmmplay/xmmplay.h>
#include <libmplayer/support.h>
#include "main.h"

/*
 * Global data ( config )
 */

char		cfg_ThemeDir[XMM_MAXPATHLEN] = "(default)";
char		cfg_SkinName[XMM_MAXPATHLEN]= "";
char		cfg_CurrentDir[XMM_MAXPATHLEN] = "";
char		cfg_DisplayFormat[256] = "%1 - %2";
int		cfg_ShowPlaylist = 0;
int		cfg_DoubleSize = 0;
int		cfg_Repeat = 0;
int		cfg_Random = 0;
XMM_List	*cfg_URLHistory = NULL;

static XMM_ConfigBlock mp_config[] =
{
    { cfg_ThemeDir,	"Theme",	XMM_CFG_TYPE_STRING,	XMM_MAXPATHLEN, "" },
    { cfg_SkinName,	"Skin",		XMM_CFG_TYPE_STRING,	XMM_MAXPATHLEN, "" },
    { cfg_CurrentDir,	"CurrentDir",	XMM_CFG_TYPE_STRING,	XMM_MAXPATHLEN, "" },
    { cfg_DisplayFormat,"DisplayFormat",XMM_CFG_TYPE_STRING,	256, "" },
    { &cfg_ShowPlaylist,"ShowPlaylist",	XMM_CFG_TYPE_BOOL,	4, "" },
    { &cfg_DoubleSize,	"DoubleSize",	XMM_CFG_TYPE_BOOL,	4, "" },
    { &cfg_Repeat,	"Repeat",	XMM_CFG_TYPE_BOOL,	4, "" },
    { &cfg_Random,	"Random",	XMM_CFG_TYPE_BOOL,	4, "" },
    { &cfg_URLHistory,	"URLHistory",	XMM_CFG_TYPE_STRING_LIST,	0, "" },
    { NULL, "", 0 }
};

/*
 * libXMM object
 */

XMM_Play	*xmmplay;

/*
 * Prototypes
 */

static int EventCB( void *priv, XMM_Event *event );

/*
 * Application entry
 */
int main( int argc, char *argv[] )
{
  char *ptr;

  gtk_set_locale();
  gtk_init( &argc, &argv );

  /* Create dirs */
  ptr = xmm_gethome_filename( "" );
  mkdir( ptr, 0700 );
  free( ptr );

  ptr = xmm_gethome_filename( "Themes" );
  mkdir( ptr, 0700 );
  free( ptr );

  ptr = xmm_gethome_filename( "tmp" );
  mkdir( ptr, 0700 );
  free( ptr );

  /* Load config */
  xmmCfg_BlockLoad( "config", "mplayer", mp_config );

  /* Add pixmap dir */
  add_pixmap_directory( LIBDIR "Data" );

  /* Initialize xmmplay */
  if(( xmmplay = xmmplay_Init()) == NULL )
  {
	printf( "\nError initializing xmmplay library: %s\n", xmm_ErrorString( XMMPLAY_2XMM( xmmplay )));
	exit(1);
  }

  if( xmm_SetEventCB( XMMPLAY_2XMM(xmmplay), EventCB, (void *)xmmplay, 1 ) < XMM_RET_OK )
  {
	printf( "\nError setting event callback: %s\n", xmm_ErrorString( XMMPLAY_2XMM( xmmplay )));
	exit(1);
  }

  /* Init windows */
  mainwin_Init();
  playlist_Init();

  /* Main loop */
  gtk_main();

  /* Close playlist and xmmplay */
  playlist_Exit();

  xmmplay_Stop( xmmplay );
  xmmplay_Close( xmmplay );
  xmmplay_Exit( xmmplay );

  /* Save config */
  xmmCfg_BlockSave( "config", "mplayer", mp_config );

  return 0;
}

/*
 * Event Handler
 *
 * TODO : Table of Content and Authorization should get Gtk windows
 */

static int EventCB( void *priv, XMM_Event *event )
{

  switch( event->type )
  {
	/* Select from Table of Contents */
	case XMM_EVENT_TOC:
		{
		    int i;
		    XMM_Event_TOC *etoc = (XMM_Event_TOC *) event;

		    fprintf( stdout, "\nTable of Contents:\n" );
		    for( i = 0; i < etoc->entries; i++ )	fprintf( stdout, "\t%2i: %s\n", i, etoc->entry[i] );
		
		    fprintf( stdout, "Please make your selection: " );
		    scanf( "%i", &etoc->selected );
		    return 0;
		}

	/* Authorization requiered */
	case XMM_EVENT_AUTH:
		{
		    char *passwd;
		    XMM_Event_Auth *eauth = (XMM_Event_Auth *) event;

		    fprintf( stdout, "\nAuthorization required:\n" );
		    fprintf( stdout, "User: " );
		    scanf( "%s", eauth->user );
		    passwd = getpass( "Password:" );
		    if( passwd == NULL )	break;
		    strcpy( eauth->passwd, passwd );
		    return 0;
		}

	/* Unknown Event: return error */
	default:
		fprintf( stderr, "ERROR: Unable to handler event of type %i\n", event->type );
		break;  
  }

  return XMM_RET_ERROR;
}
