/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef INC_main_h
#define	INC_main_h

#include <libxmm/libxmm.h>
#include <libxmm/util/list.h>
#include <libxmmplay/xmmplay.h>

/* Configuration data ( main.c ) */
extern char	cfg_ThemeDir[];
extern char	cfg_SkinName[];
extern char	cfg_CurrentDir[];
extern char	cfg_DisplayFormat[];
extern int	cfg_ShowPlaylist;
extern int	cfg_DoubleSize;
extern int	cfg_Random;
extern int	cfg_Repeat;
extern XMM_List	*cfg_URLHistory;

/* XMM_Play object */
extern XMM_Play	*xmmplay;

/* Windows ( win_about, win_pref, win_sb ) */
int	mainwin_Init( void );

/* Misc stuff */
void	mp_FileSelectCallback( char *filename, int mode );

/* General play control callback */
void	mp_on_play_release( int value );
void	mp_on_pause_release( int value );
void	mp_on_stop_release( int value );
void	mp_on_rew_release( int value );
void	mp_on_fwd_release( int value );

void	mp_on_playlist_release( int value );


/*
 * Prototypes ( for playlist control )
 */

void	playlist_show( void );
void	playlist_hide( void );
void	playlist_icon( void );

void	playlist_Init( void );
void	playlist_Exit( void );

void	playlist_UpdateDisplay( int h, int m, int s );

void	playlist_Clear( void );
void	playlist_AddFile( char *path, char *filename );
char	*playlist_Next( void );
char	*playlist_Prev( void );
char	*playlist_Current( void );
char	*playlist_nth( int num );
int	playlist_Load( char *filename );
int	playlist_Save( char *filename );
void	playlist_RemoveSelected( void );
void	playlist_CropSelected( void );

void	playlist_SetSelected( int value );
void	playlist_MoveTo( int value );

void	playlist_SelectAll( void );
void	playlist_SelectNone( void );
void	playlist_SelectInverse( void );

#endif
