/*
 *  XMMP - LinuX MultiMedia Project ( www.frozenproductions.com )
 *  Copyright (c) 1999 - 2002 Arthur Kleer <kleer@frozenproductions.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * About Window
 */

#include <gtk/gtk.h>

#include <libmplayer/support.h>
#include "interface.h"

#include "about.h"

/*
 * Global data
 */

static gchar *credit_text[] =
{	"Programming:", "Arthur Kleer", NULL,
	"Additional Programming:", "We'll see...", NULL,
	"Graphics:", "Arthur Kleer", NULL,
	NULL, NULL
};

void display_mplayer_about( void )
{
  GtkWidget	*about_window;
  GtkWidget	*credits_clist;
  int		i;

  about_window = create_about_window();
  credits_clist = lookup_widget( about_window, "about_clist" );

  /* BEGIN - This code is taken from xmms ( about.c ) and modified */

  i = 0;
  while( credit_text[i] )
  {
	gchar *temp[2];
	guint row;
		
	temp[0] = credit_text[i++];
	temp[1] = credit_text[i++];

	row = gtk_clist_append( GTK_CLIST( credits_clist ), temp );
	gtk_clist_set_selectable( GTK_CLIST( credits_clist ), row, FALSE );

	temp[0] = "";
	while( credit_text[i] )
	{
	    temp[1] = credit_text[i++];
	    row = gtk_clist_append( GTK_CLIST( credits_clist ), temp );
	    gtk_clist_set_selectable( GTK_CLIST( credits_clist ), row, FALSE );
	}

	i++;
	if( credit_text[i] )
	{
	    temp[1] = "";
	    row = gtk_clist_append( GTK_CLIST( credits_clist ), temp );
	    gtk_clist_set_selectable( GTK_CLIST( credits_clist), row, FALSE );
	}
  }

  gtk_clist_columns_autosize( GTK_CLIST( credits_clist ));
  gtk_clist_set_column_justification( GTK_CLIST( credits_clist ), 0, GTK_JUSTIFY_RIGHT );

  /* END */

  gtk_widget_show( about_window );
}
